/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.editors;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ComboObjectEditor;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.property.editors.Messages;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NameAndURIObjectEditor
extends ComboObjectEditor {
    protected String preferenceKey;

    public NameAndURIObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    public NameAndURIObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature, EClass featureEType) {
        super(parent, object, feature, featureEType);
    }

    public void setPreferenceKey(String key) {
        this.preferenceKey = key;
    }

    protected boolean canEdit() {
        if (this.comboViewer == null) {
            return true;
        }
        ISelection selection = this.comboViewer.getSelection();
        if (selection instanceof StructuredSelection) {
            String firstElement = (String)((StructuredSelection)selection).getFirstElement();
            if (firstElement != null && firstElement.isEmpty()) {
                firstElement = null;
            }
            if (firstElement != null && this.comboViewer.getData(firstElement) instanceof EObject) {
                return true;
            }
        }
        return false;
    }

    protected boolean canCreateNew() {
        return true;
    }

    public boolean setValue(Object result) {
        if (ModelUtil.isStringWrapper((Object)result)) {
            result = ModelUtil.getStringWrapperValue((Object)result);
        }
        return super.setValue(result);
    }

    public Object getValue() {
        Object value = this.object.eGet(this.feature);
        if (value == null) {
            return "";
        }
        Hashtable choices = this.getChoiceOfValues(this.object, this.feature);
        for (Map.Entry entry : choices.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return value.toString();
    }

    protected EObject createObject() throws Exception {
        Hashtable choices = this.getChoiceOfValues(this.object, this.feature);
        NameAndURIDialog dialog = new NameAndURIDialog(this.getDiagramEditor().getEditorSite().getShell(), NLS.bind((String)Messages.NameAndURIObjectEditor_Create_New_Title, (Object)ModelUtil.toCanonicalString((String)this.preferenceKey)), choices, null, null);
        if (dialog.open() == 0) {
            Bpmn2Preferences prefs = (Bpmn2Preferences)this.getDiagramEditor().getAdapter(Bpmn2Preferences.class);
            String newURI = dialog.getURI();
            String newName = dialog.getName();
            prefs.addNameAndURI(this.preferenceKey, newName, newURI);
            return ModelUtil.createStringWrapper((String)newURI);
        }
        throw new OperationCanceledException(Messages.NameAndURIObjectEditor_Dialog_Cancelled);
    }

    protected EObject editObject(EObject value) throws Exception {
        Hashtable choices = this.getChoiceOfValues(this.object, this.feature);
        final String oldURI = ModelUtil.getStringWrapperTextValue((Object)value);
        String oldName = (String)this.getValue();
        NameAndURIDialog dialog = new NameAndURIDialog(this.getDiagramEditor().getEditorSite().getShell(), NLS.bind((String)Messages.NameAndURIObjectEditor_Edit_Title, (Object)ModelUtil.toCanonicalString((String)this.preferenceKey)), choices, oldName, oldURI);
        if (dialog.open() == 0) {
            final String newURI = dialog.getURI();
            String newName = dialog.getName();
            if (!newURI.equals(oldURI)) {
                final Definitions definitions = ModelUtil.getDefinitions((Object)this.object);
                if (definitions != null) {
                    TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            String featureName = NameAndURIObjectEditor.this.feature.getName();
                            TreeIterator iter = definitions.eAllContents();
                            while (iter.hasNext()) {
                                String uri;
                                EObject o = (EObject)iter.next();
                                EStructuralFeature f = o.eClass().getEStructuralFeature(featureName);
                                if (f == null || !oldURI.equals(uri = (String)o.eGet(f))) continue;
                                o.eSet(f, (Object)newURI);
                            }
                        }
                    });
                }
                Bpmn2Preferences prefs = (Bpmn2Preferences)this.getDiagramEditor().getAdapter(Bpmn2Preferences.class);
                prefs.removeNameAndURI(this.preferenceKey, oldName);
                prefs.addNameAndURI(this.preferenceKey, newName, newURI);
                return ModelUtil.createStringWrapper((String)newURI);
            }
        }
        throw new OperationCanceledException(Messages.NameAndURIObjectEditor_Dialog_Cancelled);
    }

    public class NameAndURIDialog
    extends InputDialog {
        private String nameString;
        private Text nameText;

        public NameAndURIDialog(Shell shell, String title, Map<String, Object> choices, String nameString, String uriString) {
            super(shell, title, Messages.NameAndURIObjectEditor_URI_Label, uriString, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.isEmpty()) {
                        return Messages.NameAndURIObjectEditor_Invalid_Empty;
                    }
                    return null;
                }
            });
            this.nameString = nameString;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = this.createMyComposite(parent);
            Label label = new Label(composite, 64);
            label.setText(Messages.NameAndURIObjectEditor_Name_Label);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.nameText = new Text(composite, this.getInputTextStyle());
            this.nameText.setLayoutData((Object)new GridData(768));
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NameAndURIDialog.this.validateInput();
                }
            });
            return super.createDialogArea(parent);
        }

        private Composite createMyComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            NameAndURIDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void validateInput() {
            String errorMessage = this.getValidator().isValid(this.nameText.getText());
            if (errorMessage == null) {
                super.validateInput();
            } else {
                this.setErrorMessage(errorMessage);
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.nameText.setFocus();
            if (this.nameString != null) {
                this.nameText.setText(this.nameString);
                this.nameText.selectAll();
            }
            this.validateInput();
        }

        protected void buttonPressed(int buttonId) {
            this.nameString = buttonId == 0 ? this.nameText.getText() : null;
            super.buttonPressed(buttonId);
        }

        public String getName() {
            return this.nameString;
        }

        public String getURI() {
            return super.getValue();
        }
    }
}

