/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.projectimport;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import com.gradleware.tooling.toolingmodel.util.Pair;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.gradle.Specs;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.projectimport.internal.DefaultProjectCreatedEvent;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.buildship.core.workspace.ClasspathDefinition;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.launching.JavaRuntime;

public final class ProjectImportJob
extends ToolingApiWorkspaceJob {
    private final FixedRequestAttributes fixedAttributes;
    private final ImmutableList<String> workingSets;
    private final AsyncHandler initializer;

    public ProjectImportJob(ProjectImportConfiguration configuration, AsyncHandler initializer) {
        super("Importing Gradle project");
        this.fixedAttributes = configuration.toFixedAttributes();
        this.workingSets = (Boolean)configuration.getApplyWorkingSets().getValue() != false ? ImmutableList.copyOf((Collection)((Collection)configuration.getWorkingSets().getValue())) : ImmutableList.of();
        this.initializer = (AsyncHandler)Preconditions.checkNotNull((Object)initializer);
        this.setUser(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runToolingApiJobInWorkspace(IProgressMonitor monitor) {
        monitor.beginTask("Import Gradle project", 100);
        this.initializer.run((IProgressMonitor)new SubProgressMonitor(monitor, 10));
        IJobManager manager = Job.getJobManager();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        manager.beginRule((ISchedulingRule)workspaceRoot, monitor);
        try {
            OmniEclipseGradleBuild eclipseGradleBuild = this.fetchEclipseGradleBuild((IProgressMonitor)new SubProgressMonitor(monitor, 50));
            OmniEclipseProject rootProject = eclipseGradleBuild.getRootEclipseProject();
            List allProjects = rootProject.getAll();
            for (OmniEclipseProject project : allProjects) {
                this.importProject(project, eclipseGradleBuild, (IProgressMonitor)new SubProgressMonitor(monitor, 50 / allProjects.size()));
            }
        }
        finally {
            manager.endRule((ISchedulingRule)workspaceRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OmniEclipseGradleBuild fetchEclipseGradleBuild(IProgressMonitor monitor) {
        monitor.beginTask("Load Eclipse Gradle project", -1);
        try {
            ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
            ImmutableList listeners = ImmutableList.of((Object)new DelegatingProgressListener(monitor));
            TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), null, (List)listeners, (List)ImmutableList.of(), this.getToken());
            ModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(this.fixedAttributes);
            OmniEclipseGradleBuild omniEclipseGradleBuild = repository.fetchEclipseGradleBuild(transientAttributes, FetchStrategy.FORCE_RELOAD);
            return omniEclipseGradleBuild;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importProject(OmniEclipseProject project, OmniEclipseGradleBuild eclipseGradleBuild, IProgressMonitor monitor) {
        monitor.beginTask("Import project " + project.getName(), 3);
        try {
            IProject workspaceProject;
            WorkspaceOperations workspaceOperations = CorePlugin.workspaceOperations();
            File projectDirectory = project.getProjectDirectory();
            Optional<IProjectDescription> projectDescription = workspaceOperations.findProjectInFolder(projectDirectory, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ImmutableList filteredSubFolders = ImmutableList.builder().addAll(this.collectChildProjectLocations(project)).add((Object)this.getBuildDirectory(eclipseGradleBuild, project)).add((Object)this.getDotGradleDirectory(project)).build();
            ImmutableList gradleNature = ImmutableList.of((Object)"org.eclipse.buildship.core.gradleprojectnature");
            if (projectDescription.isPresent()) {
                workspaceProject = workspaceOperations.includeProject((IProjectDescription)projectDescription.get(), (List<File>)filteredSubFolders, (List<String>)gradleNature, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            } else {
                workspaceProject = workspaceOperations.createProject(project.getName(), project.getProjectDirectory(), (List<File>)filteredSubFolders, (List<String>)gradleNature, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (this.isJavaProject(project)) {
                    IPath jre = JavaRuntime.getDefaultJREContainerEntry().getPath();
                    ClasspathDefinition classpath = new ClasspathDefinition((List<Pair<IPath, IPath>>)ImmutableList.of(), (List<IPath>)ImmutableList.of(), (List<String>)ImmutableList.of(), jre);
                    workspaceOperations.createJavaProject(workspaceProject, classpath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
            }
            ProjectConfiguration projectConfiguration = ProjectConfiguration.from(this.fixedAttributes, project);
            CorePlugin.projectConfigurationManager().saveProjectConfiguration(projectConfiguration, workspaceProject);
            DefaultProjectCreatedEvent event = new DefaultProjectCreatedEvent(workspaceProject, (List<String>)this.workingSets);
            CorePlugin.listenerRegistry().dispatch(event);
        }
        finally {
            monitor.done();
        }
    }

    private List<File> collectChildProjectLocations(OmniEclipseProject project) {
        return FluentIterable.from((Iterable)project.getChildren()).transform((Function)new Function<OmniEclipseProject, File>(){

            public File apply(OmniEclipseProject project) {
                return project.getProjectDirectory();
            }
        }).toList();
    }

    private File getBuildDirectory(OmniEclipseGradleBuild eclipseGradleBuild, OmniEclipseProject project) {
        Optional gradleProject = eclipseGradleBuild.getRootProject().tryFind(Specs.gradleProjectMatchesProjectPath(project.getPath()));
        Maybe buildScript = ((OmniGradleProject)gradleProject.get()).getBuildDirectory();
        if (buildScript.isPresent() && buildScript.get() != null) {
            return (File)buildScript.get();
        }
        return new File(project.getProjectDirectory(), "build");
    }

    private File getDotGradleDirectory(OmniEclipseProject project) {
        return new File(project.getProjectDirectory(), ".gradle");
    }

    private boolean isJavaProject(OmniEclipseProject modelProject) {
        return !modelProject.getSourceDirectories().isEmpty();
    }
}

