/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.CompositeRequest;
import com.gradleware.tooling.toolingclient.GradleBuildIdentifier;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingclient.SimpleRequest;
import com.gradleware.tooling.toolingutils.ImmutableCollection;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.gradle.api.Nullable;

public final class FixedRequestAttributes {
    private final File projectDir;
    private final File gradleUserHome;
    private final GradleDistribution gradleDistribution;
    private final File javaHome;
    private final ImmutableList<String> jvmArguments;
    private final ImmutableList<String> arguments;

    public FixedRequestAttributes(File projectDir, File gradleUserHome, GradleDistribution gradleDistribution, File javaHome, List<String> jvmArguments, List<String> arguments) {
        this.projectDir = FixedRequestAttributes.canonicalize((File)Preconditions.checkNotNull((Object)projectDir));
        this.gradleUserHome = gradleUserHome == null ? null : FixedRequestAttributes.canonicalize(gradleUserHome);
        this.gradleDistribution = (GradleDistribution)Preconditions.checkNotNull((Object)gradleDistribution);
        this.javaHome = javaHome == null ? null : FixedRequestAttributes.canonicalize(javaHome);
        this.jvmArguments = ImmutableList.copyOf(jvmArguments);
        this.arguments = ImmutableList.copyOf(arguments);
    }

    private static File canonicalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    @Nullable
    public File getGradleUserHome() {
        return this.gradleUserHome;
    }

    public GradleDistribution getGradleDistribution() {
        return this.gradleDistribution;
    }

    @Nullable
    public File getJavaHome() {
        return this.javaHome;
    }

    @ImmutableCollection
    public List<String> getJvmArguments() {
        return this.jvmArguments;
    }

    @ImmutableCollection
    public List<String> getArguments() {
        return this.arguments;
    }

    public void apply(SimpleRequest<?> request) {
        request.projectDir(this.projectDir);
        request.gradleUserHomeDir(this.gradleUserHome);
        request.gradleDistribution(this.gradleDistribution);
        request.javaHomeDir(this.javaHome);
        request.jvmArguments((String[])this.jvmArguments.toArray((Object[])new String[this.jvmArguments.size()]));
        request.arguments((String[])this.arguments.toArray((Object[])new String[this.arguments.size()]));
    }

    public void apply(CompositeRequest<?> request) {
        GradleBuildIdentifier participant = new GradleBuildIdentifier(this.projectDir, this.gradleDistribution);
        request.addParticipants(new GradleBuildIdentifier[]{participant});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FixedRequestAttributes that = (FixedRequestAttributes)other;
        return Objects.equal((Object)this.projectDir, (Object)that.projectDir) && Objects.equal((Object)this.gradleUserHome, (Object)that.gradleUserHome) && Objects.equal((Object)this.gradleDistribution, (Object)that.gradleDistribution) && Objects.equal((Object)this.javaHome, (Object)that.javaHome) && Objects.equal(this.jvmArguments, that.jvmArguments) && Objects.equal(this.arguments, that.arguments);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectDir, this.gradleUserHome, this.gradleDistribution, this.javaHome, this.jvmArguments, this.arguments});
    }
}

