/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectDependency;
import com.gradleware.tooling.toolingmodel.OmniEclipseSourceDirectory;
import com.gradleware.tooling.toolingmodel.OmniExternalDependency;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.gradle.Specs;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;

public final class GradleClasspathContainerInitializer
extends ClasspathContainerInitializer {
    private static final String CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL = "FROM_GRADLE_MODEL";

    public void initialize(IPath containerPath, IJavaProject javaProject) {
        this.scheduleClasspathInitialization(containerPath, javaProject, FetchStrategy.LOAD_IF_NOT_CACHED);
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) {
        this.scheduleClasspathInitialization(containerPath, project, FetchStrategy.FORCE_RELOAD);
    }

    private void scheduleClasspathInitialization(final IPath containerPath, final IJavaProject javaProject, final FetchStrategy fetchStrategy) {
        new ToolingApiWorkspaceJob("Initialize Gradle classpath for project '" + javaProject.getElementName() + "'"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runToolingApiJobInWorkspace(IProgressMonitor monitor) throws Exception {
                monitor.beginTask("Initializing classpath", 100);
                IJobManager manager = Job.getJobManager();
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                manager.beginRule((ISchedulingRule)workspaceRoot, monitor);
                try {
                    GradleClasspathContainerInitializer.this.internalInitialize(containerPath, javaProject, fetchStrategy, monitor);
                }
                finally {
                    manager.endRule((ISchedulingRule)workspaceRoot);
                }
            }
        }.schedule();
    }

    private void internalInitialize(IPath containerPath, IJavaProject project, FetchStrategy fetchStrategy, IProgressMonitor monitor) throws JavaModelException {
        Optional<OmniEclipseProject> eclipseProject = this.findEclipseProject(project.getProject(), fetchStrategy);
        if (!eclipseProject.isPresent()) {
            throw new GradlePluginsRuntimeException(String.format("Cannot find Eclipse project model for project %s.", project.getProject()));
        }
        List<IClasspathEntry> sourceFolders = this.collectSourceFolders((OmniEclipseProject)eclipseProject.get(), project);
        this.updateSourceFoldersInClasspath(sourceFolders, project, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
        ImmutableList<IClasspathEntry> dependencies = this.collectDependencies((OmniEclipseProject)eclipseProject.get());
        this.setClasspathContainer((List<IClasspathEntry>)dependencies, project, containerPath, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
        project.save((IProgressMonitor)new SubProgressMonitor(monitor, 25), true);
    }

    private Optional<OmniEclipseProject> findEclipseProject(IProject project, FetchStrategy fetchStrategy) {
        ProjectConfiguration configuration = CorePlugin.projectConfigurationManager().readProjectConfiguration(project);
        OmniEclipseGradleBuild eclipseGradleBuild = this.fetchEclipseGradleBuild(configuration.getRequestAttributes(), fetchStrategy);
        return eclipseGradleBuild.getRootEclipseProject().tryFind(Specs.eclipseProjectMatchesProjectPath(configuration.getProjectPath()));
    }

    private OmniEclipseGradleBuild fetchEclipseGradleBuild(FixedRequestAttributes fixedRequestAttributes, FetchStrategy fetchStrategy) {
        ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        ImmutableList noProgressListeners = ImmutableList.of();
        ImmutableList noTypedProgressListeners = ImmutableList.of();
        CancellationToken cancellationToken = GradleConnector.newCancellationTokenSource().token();
        TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), null, (List)noProgressListeners, (List)noTypedProgressListeners, cancellationToken);
        ModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(fixedRequestAttributes);
        return repository.fetchEclipseGradleBuild(transientAttributes, fetchStrategy);
    }

    private List<IClasspathEntry> collectSourceFolders(OmniEclipseProject gradleProject, final IJavaProject workspaceProject) {
        return FluentIterable.from((Iterable)gradleProject.getSourceDirectories()).transform((Function)new Function<OmniEclipseSourceDirectory, IClasspathEntry>(){

            public IClasspathEntry apply(OmniEclipseSourceDirectory directory) {
                IFolder sourceDirectory = workspaceProject.getProject().getFolder(Path.fromOSString((String)directory.getPath()));
                FileUtils.ensureFolderHierarchyExists(sourceDirectory);
                IPackageFragmentRoot root = workspaceProject.getPackageFragmentRoot((IResource)sourceDirectory);
                IClasspathAttribute fromGradleModel = JavaCore.newClasspathAttribute((String)GradleClasspathContainerInitializer.CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL, (String)"true");
                return JavaCore.newSourceEntry((IPath)root.getPath(), (IPath[])new IPath[0], (IPath[])new IPath[0], null, (IClasspathAttribute[])new IClasspathAttribute[]{fromGradleModel});
            }
        }).toList();
    }

    private void updateSourceFoldersInClasspath(List<IClasspathEntry> gradleModelSourceFolders, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        ImmutableSet gradleModelSourcePaths = FluentIterable.from(gradleModelSourceFolders).transform((Function)new Function<IClasspathEntry, String>(){

            public String apply(IClasspathEntry entry) {
                return entry.getPath().toString();
            }
        }).toSet();
        ImmutableList rawClasspath = ImmutableList.copyOf((Object[])project.getRawClasspath());
        ImmutableList manuallyAddedSourceFolders = FluentIterable.from((Iterable)rawClasspath).filter((Predicate)new Predicate<IClasspathEntry>((Set)gradleModelSourcePaths){
            final /* synthetic */ Set val$gradleModelSourcePaths;
            {
                this.val$gradleModelSourcePaths = set;
            }

            public boolean apply(IClasspathEntry entry) {
                if (this.val$gradleModelSourcePaths.contains(entry.getPath().toString())) {
                    return false;
                }
                for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
                    if (!attribute.getName().equals(GradleClasspathContainerInitializer.CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL) || !attribute.getValue().equals("true")) continue;
                    return false;
                }
                return true;
            }
        }).toList();
        ImmutableList newRawClasspathEntries = ImmutableList.builder().addAll(gradleModelSourceFolders).addAll((Iterable)manuallyAddedSourceFolders).build();
        IClasspathEntry[] newRawClasspath = (IClasspathEntry[])newRawClasspathEntries.toArray((Object[])new IClasspathEntry[newRawClasspathEntries.size()]);
        project.setRawClasspath(newRawClasspath, monitor);
    }

    private ImmutableList<IClasspathEntry> collectDependencies(final OmniEclipseProject gradleProject) {
        ImmutableList projectDependencies = FluentIterable.from((Iterable)gradleProject.getProjectDependencies()).transform((Function)new Function<OmniEclipseProjectDependency, IClasspathEntry>(){

            public IClasspathEntry apply(OmniEclipseProjectDependency dependency) {
                OmniEclipseProject dependentProject = (OmniEclipseProject)gradleProject.getRoot().tryFind(Specs.eclipseProjectMatchesProjectPath(dependency.getTargetProjectPath())).get();
                Path path = new Path("/" + dependentProject.getName());
                return JavaCore.newProjectEntry((IPath)path, (boolean)dependency.isExported());
            }
        }).toList();
        ImmutableList externalDependencies = FluentIterable.from((Iterable)gradleProject.getExternalDependencies()).filter((Predicate)new Predicate<OmniExternalDependency>(){

            public boolean apply(OmniExternalDependency dependency) {
                String name = dependency.getFile().getName();
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        }).transform((Function)new Function<OmniExternalDependency, IClasspathEntry>(){

            public IClasspathEntry apply(OmniExternalDependency dependency) {
                IPath jar = Path.fromOSString((String)dependency.getFile().getAbsolutePath());
                IPath sourceJar = dependency.getSource() != null ? Path.fromOSString((String)dependency.getSource().getAbsolutePath()) : null;
                return JavaCore.newLibraryEntry((IPath)jar, (IPath)sourceJar, null, (boolean)dependency.isExported());
            }
        }).toList();
        return ImmutableList.builder().addAll((Iterable)projectDependencies).addAll((Iterable)externalDependencies).build();
    }

    private void setClasspathContainer(List<IClasspathEntry> classpathEntries, IJavaProject project, IPath containerPath, IProgressMonitor monitor) throws JavaModelException {
        Path classpathContainerPath = new Path("org.eclipse.buildship.core.gradleclasspathcontainer");
        GradleClasspathContainer classpathContainer = new GradleClasspathContainer("Project and External Dependencies", classpathContainerPath, classpathEntries);
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{classpathContainer}, (IProgressMonitor)monitor);
    }

    private static final class GradleClasspathContainer
    implements IClasspathContainer {
        private final String containerName;
        private final Path path;
        private final IClasspathEntry[] classpathEntries;

        private GradleClasspathContainer(String containerName, Path path, List<IClasspathEntry> classpathEntries) {
            this.containerName = (String)Preconditions.checkNotNull((Object)containerName);
            this.path = (Path)Preconditions.checkNotNull((Object)path);
            this.classpathEntries = (IClasspathEntry[])Iterables.toArray(classpathEntries, IClasspathEntry.class);
        }

        public String getDescription() {
            return this.containerName;
        }

        public IPath getPath() {
            return this.path;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.classpathEntries;
        }

        public int getKind() {
            return 1;
        }
    }
}

