/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.console;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.console.GradleConsole;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;

public final class RerunBuildExecutionAction
extends Action {
    private final GradleConsole gradleConsole;

    public RerunBuildExecutionAction(GradleConsole gradleConsole) {
        this.gradleConsole = (GradleConsole)((Object)Preconditions.checkNotNull((Object)((Object)gradleConsole)));
        this.setToolTipText(UiMessages.Action_RerunBuild_Tooltip);
        this.setImageDescriptor(PluginImages.RERUN_BUILD.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.RERUN_BUILD.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.registerJobChangeListener();
    }

    private void registerJobChangeListener() {
        Optional job = this.gradleConsole.getProcessDescription().getJob();
        if (job.isPresent()) {
            ((Job)job.get()).addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    RerunBuildExecutionAction.this.setEnabled(event.getJob().getState() == 0);
                }
            });
        }
        if (!job.isPresent()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(((Job)job.get()).getState() == 0);
        }
    }

    public void run() {
        ILaunchConfiguration launchConfiguration = ((ILaunch)this.gradleConsole.getProcessDescription().getLaunch().get()).getLaunchConfiguration();
        DebugUITools.launch((ILaunchConfiguration)launchConfiguration, (String)"run");
    }
}

