/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.progress;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.core.AggregateException;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.util.progress.ToolingApiCommand;
import org.eclipse.buildship.core.util.string.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.TestExecutionException;

public final class ToolingApiInvoker {
    private final String workName;
    private final boolean notifyUserAboutBuildFailures;

    public ToolingApiInvoker(String workName, boolean notifyUserAboutBuildFailures) {
        this.workName = (String)Preconditions.checkNotNull((Object)workName);
        this.notifyUserAboutBuildFailures = notifyUserAboutBuildFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus invoke(ToolingApiCommand command, IProgressMonitor progressMonitor) {
        try {
            command.run();
            IStatus iStatus = this.handleSuccess();
            return iStatus;
        }
        catch (Throwable t) {
            IStatus iStatus = this.handleFailure(t);
            return iStatus;
        }
        finally {
            progressMonitor.done();
        }
    }

    private IStatus handleFailure(Throwable failure) {
        if (failure instanceof OperationCanceledException) {
            return this.handleOperationCanceled((OperationCanceledException)failure);
        }
        if (failure instanceof BuildCancelledException) {
            return this.handleBuildCanceled((BuildCancelledException)failure);
        }
        if (failure instanceof BuildException) {
            return this.handleBuildFailed((BuildException)failure);
        }
        if (failure instanceof GradleConnectionException) {
            return this.handleGradleConnectionFailed((GradleConnectionException)failure);
        }
        if (failure instanceof GradlePluginsRuntimeException) {
            return this.handlePluginFailed((GradlePluginsRuntimeException)failure);
        }
        if (failure instanceof AggregateException) {
            return this.handleMultiException((AggregateException)failure);
        }
        return this.handleUnknownFailed(failure);
    }

    private IStatus handleSuccess() {
        String message = String.format("%s succeeded.", this.workName);
        CorePlugin.logger().info(message);
        return Status.OK_STATUS;
    }

    private IStatus handleOperationCanceled(OperationCanceledException e) {
        String message = String.format("%s cancelled.", this.workName);
        CorePlugin.logger().info(message, (Throwable)e);
        return ToolingApiInvoker.createCancelStatus(message, (Exception)e);
    }

    private IStatus handleBuildCanceled(BuildCancelledException e) {
        String message = String.format("%s cancelled.", this.workName);
        CorePlugin.logger().info(message, e);
        return ToolingApiInvoker.createCancelStatus(message, (Exception)((Object)e));
    }

    private IStatus handleBuildFailed(BuildException e) {
        String message = String.format("%s failed due to an error in the referenced Gradle build.", this.workName);
        CorePlugin.logger().warn(message, (Throwable)e);
        if (this.shouldSendUserNotification((Throwable)e)) {
            CorePlugin.userNotification().errorOccurred(String.format("%s failed", this.workName), message, this.collectErrorMessages((Throwable)e), 2, (Throwable)e);
        }
        return ToolingApiInvoker.createInfoStatus(message, (Throwable)e);
    }

    private IStatus handleGradleConnectionFailed(GradleConnectionException e) {
        String message = String.format("%s failed due to an error connecting to the Gradle build.", this.workName);
        CorePlugin.logger().warn(message, (Throwable)e);
        if (this.shouldSendUserNotification((Throwable)e)) {
            CorePlugin.userNotification().errorOccurred(String.format("%s failed", this.workName), message, this.collectErrorMessages((Throwable)e), 2, (Throwable)e);
        }
        return ToolingApiInvoker.createInfoStatus(message, (Throwable)e);
    }

    private IStatus handlePluginFailed(GradlePluginsRuntimeException e) {
        String message = String.format("%s failed due to an error configuring Eclipse.", this.workName);
        CorePlugin.logger().error(message, e);
        if (this.shouldSendUserNotification(e)) {
            CorePlugin.userNotification().errorOccurred(String.format("%s failed", this.workName), message, this.collectErrorMessages(e), 4, e);
        }
        return ToolingApiInvoker.createInfoStatus(message, e);
    }

    private IStatus handleUnknownFailed(Throwable t) {
        String message = String.format("%s failed due to an unexpected error.", this.workName);
        CorePlugin.logger().error(message, t);
        if (this.shouldSendUserNotification(t)) {
            CorePlugin.userNotification().errorOccurred(String.format("%s failed", this.workName), message, this.collectErrorMessages(t), 4, t);
        }
        return ToolingApiInvoker.createInfoStatus(message, t);
    }

    private IStatus handleMultiException(AggregateException e) {
        MultiStatus status = new MultiStatus("org.eclipse.buildship.core", 0, "Multiple problems", null);
        for (Throwable cause : e.getCauses()) {
            IStatus child = this.handleFailure(cause);
            status.add(child);
        }
        return status;
    }

    private boolean shouldSendUserNotification(Throwable t) {
        if (t instanceof BuildCancelledException) {
            return false;
        }
        if (t instanceof BuildException || t instanceof TestExecutionException) {
            return this.notifyUserAboutBuildFailures;
        }
        return true;
    }

    private String collectErrorMessages(Throwable t) {
        ArrayList messages = Lists.newArrayList();
        Throwable cause = t.getCause();
        if (cause != null) {
            this.collectCausesRecursively(cause, messages);
        }
        String messageStack = Joiner.on((char)'\n').join(StringUtils.removeAdjacentDuplicates(messages));
        return t.getMessage() + (messageStack.isEmpty() ? "" : "\n\n" + messageStack);
    }

    private void collectCausesRecursively(Throwable t, List<String> messages) {
        List singleLineMessages = Splitter.on((char)'\n').omitEmptyStrings().splitToList((CharSequence)Strings.nullToEmpty((String)t.getMessage()));
        messages.addAll(singleLineMessages);
        Throwable cause = t.getCause();
        if (cause != null) {
            this.collectCausesRecursively(cause, messages);
        }
    }

    private static Status createInfoStatus(String message, Throwable t) {
        return new Status(1, "org.eclipse.buildship.core", message, t);
    }

    private static Status createCancelStatus(String message, Exception e) {
        return new Status(8, "org.eclipse.buildship.core", message, (Throwable)e);
    }
}

