/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.launch.RunGradleJvmTestLaunchRequestJob;
import org.eclipse.buildship.core.launch.TestMethod;
import org.eclipse.buildship.core.launch.TestTarget;
import org.eclipse.buildship.core.launch.TestType;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.ui.launch.EditorJavaElementResolver;
import org.eclipse.buildship.ui.launch.JavaElementResolver;
import org.eclipse.buildship.ui.launch.LaunchMessages;
import org.eclipse.buildship.ui.launch.SelectionJavaElementResolver;
import org.eclipse.buildship.ui.launch.TestLaunchShortcutValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public final class TestLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        SelectionJavaElementResolver resolver = SelectionJavaElementResolver.from(selection);
        this.launch(resolver);
    }

    public void launch(IEditorPart editor, String mode) {
        EditorJavaElementResolver resolver = EditorJavaElementResolver.from(editor);
        this.launch(resolver);
    }

    private void launch(JavaElementResolver resolver) {
        List<IMethod> methods;
        List<IType> types = resolver.resolveTypes();
        if (TestLaunchShortcutValidator.validateTypesAndMethods(types, methods = resolver.resolveMethods())) {
            ImmutableList.Builder targets = ImmutableList.builder();
            targets.addAll(TestLaunchShortcut.convertTypesToTestTargets(types));
            targets.addAll(TestLaunchShortcut.convertMethodsToTestTargets(methods));
            GradleRunConfigurationAttributes runConfigurationAttributes = this.collectRunConfigurationAttributes((IProject)resolver.findFirstContainerProject().get());
            new RunGradleJvmTestLaunchRequestJob((List)targets.build(), runConfigurationAttributes).schedule();
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private GradleRunConfigurationAttributes collectRunConfigurationAttributes(IProject project) {
        FixedRequestAttributes requestAttributes = CorePlugin.projectConfigurationManager().readProjectConfiguration(project).getRequestAttributes();
        String projectDir = requestAttributes.getProjectDir().getAbsolutePath();
        GradleDistribution gradleDistribution = requestAttributes.getGradleDistribution();
        String javaHome = (String)FileUtils.getAbsolutePath((File)requestAttributes.getJavaHome()).orNull();
        List jvmArguments = requestAttributes.getJvmArguments();
        List arguments = requestAttributes.getArguments();
        boolean showExecutionView = true;
        boolean showConsoleView = true;
        return GradleRunConfigurationAttributes.with((List)ImmutableList.of(), (String)projectDir, (GradleDistribution)gradleDistribution, (String)javaHome, (List)jvmArguments, (List)arguments, (boolean)showExecutionView, (boolean)showConsoleView, (boolean)true);
    }

    private void showNoTestsFoundDialog() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                MessageDialog.openWarning((Shell)shell, (String)LaunchMessages.Test_Not_Found_Dialog_Title, (String)String.format("%s%n%s", LaunchMessages.Test_Not_Found_Dialog_Message, LaunchMessages.Test_Not_Found_Dialog_Details));
            }
        });
    }

    private static List<TestTarget> convertTypesToTestTargets(Collection<IType> types) {
        return FluentIterable.from(types).transform((Function)new Function<IType, TestTarget>(){

            public TestTarget apply(IType type) {
                return TestType.from((IType)type);
            }
        }).toList();
    }

    private static List<TestTarget> convertMethodsToTestTargets(Collection<IMethod> methods) {
        return FluentIterable.from(methods).transform((Function)new Function<IMethod, TestTarget>(){

            public TestTarget apply(IMethod method) {
                return TestMethod.from((IMethod)method);
            }
        }).toList();
    }
}

