/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.notification;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.util.font.FontUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class ExceptionDetailsDialog
extends Dialog {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int COPY_EXCEPTION_BUTTON_ID = 25;
    private final Image image;
    private final String title;
    private final String message;
    private final String details;
    private final Throwable throwable;
    private Button detailsButton;
    private Control stackTraceArea;
    private Clipboard clipboard;

    public ExceptionDetailsDialog(Shell shell, String title, String message, String details, int severity, Throwable throwable) {
        super((IShellProvider)new SameShellProvider((Control)shell));
        this.image = this.getIconForSeverity(severity, shell);
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this.details = (String)Preconditions.checkNotNull((Object)details);
        this.throwable = (Throwable)Preconditions.checkNotNull((Object)throwable);
        this.setShellStyle(67696);
    }

    private Image getIconForSeverity(int severity, Shell shell) {
        int swtImageKey;
        switch (severity) {
            case 0: 
            case 1: {
                swtImageKey = 2;
                break;
            }
            case 2: 
            case 8: {
                swtImageKey = 8;
                break;
            }
            case 4: {
                swtImageKey = 1;
                break;
            }
            default: {
                throw new GradlePluginsRuntimeException("Can't find image for severity: " + severity);
            }
        }
        return shell.getDisplay().getSystemImage(swtImageKey);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayoutData((Object)new GridData(768));
        ((GridLayout)container.getLayout()).numColumns = 2;
        Label imageLabel = new Label(container, 0);
        this.image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(this.image);
        imageLabel.setLayoutData((Object)new GridData(66));
        Composite textArea = new Composite(container, 0);
        GridLayout textAreaLayout = new GridLayout(1, false);
        textAreaLayout.verticalSpacing = FontUtils.getFontHeightInPixels(parent.getFont());
        textArea.setLayout((Layout)textAreaLayout);
        GridData textAreaLayoutData = new GridData(4, 4, true, true, 1, 1);
        textAreaLayoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        textArea.setLayoutData((Object)textAreaLayoutData);
        Label messageLabel = new Label(textArea, 64);
        messageLabel.setText(this.message);
        GridData messageLabelGridData = new GridData();
        messageLabelGridData.verticalAlignment = 128;
        messageLabelGridData.grabExcessHorizontalSpace = true;
        messageLabel.setLayoutData((Object)messageLabelGridData);
        Label detailsLabel = new Label(textArea, 64);
        detailsLabel.setText(this.details);
        GridData detailsLabelGridData = new GridData();
        detailsLabelGridData.verticalAlignment = 128;
        detailsLabelGridData.grabExcessHorizontalSpace = true;
        detailsLabel.setLayoutData((Object)detailsLabelGridData);
        this.clipboard = new Clipboard(this.getShell().getDisplay());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button copyExceptionButton = this.createButton(parent, 25, "", false);
        copyExceptionButton.setToolTipText(UiMessages.Button_CopyFailuresToClipboard_Tooltip);
        copyExceptionButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okButton.setFocus();
    }

    protected void setButtonLayoutData(Button button) {
        if (button.getData() != null && button.getData().equals(25)) {
            GridDataFactory.swtDefaults().applyTo((Control)button);
            return;
        }
        super.setButtonLayoutData(button);
    }

    protected void initializeBounds() {
        Composite buttonBar = (Composite)this.getButtonBar();
        GridLayout layout = (GridLayout)buttonBar.getLayout();
        layout.makeColumnsEqualWidth = false;
        super.initializeBounds();
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleStacktraceArea();
        } else if (id == 25) {
            this.copyErrorToClipboard();
        } else {
            super.buttonPressed(id);
        }
    }

    private void copyErrorToClipboard() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.message);
        sb.append(LINE_SEPARATOR);
        sb.append(this.details);
        sb.append(LINE_SEPARATOR);
        sb.append(this.getStackTrace());
        this.clipboard.setContents((Object[])new String[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void toggleStacktraceArea() {
        if (this.stackTraceArea == null) {
            this.stackTraceArea = this.createStacktraceArea((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        } else {
            this.stackTraceArea.dispose();
            this.stackTraceArea = null;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        }
        Point oldSize = this.getContents().getSize();
        Point newSize = this.getContents().computeSize(-1, -1);
        Point oldWindowSize = this.getShell().getSize();
        Point newWindowSize = new Point(oldWindowSize.x, oldWindowSize.y + (newSize.y - oldSize.y));
        Point windowLocation = this.getShell().getLocation();
        Rectangle screenArea = this.getContents().getDisplay().getClientArea();
        if (newWindowSize.y > screenArea.height - (windowLocation.y - screenArea.y)) {
            newWindowSize.y = screenArea.height - (windowLocation.y - screenArea.y);
        }
        this.getShell().setSize(newWindowSize);
        ((Composite)this.getContents()).layout();
    }

    private Control createStacktraceArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout containerLayout = new GridLayout();
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        container.setLayout((Layout)containerLayout);
        Text text = new Text(container, 2826);
        text.setLayoutData((Object)new GridData(1808));
        text.setText(this.getStackTrace());
        return container;
    }

    private String getStackTrace() {
        StringWriter writer = new StringWriter(1000);
        this.throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        return super.close();
    }
}

