/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.core.internal.util.binding.Property;
import org.eclipse.buildship.ui.internal.wizard.project.AbstractProjectWizard;
import org.eclipse.buildship.ui.internal.wizard.project.AbstractWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportConfiguration;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectWizardMessages;
import org.eclipse.buildship.ui.internal.wizard.project.WelcomePageContent;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public final class GradleWelcomeWizardPage
extends AbstractWizardPage {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final WelcomePageContent welcomePageContent;
    private final Font headerFont;

    public GradleWelcomeWizardPage(ProjectImportConfiguration configuration, WelcomePageContent welcomePageContent) {
        super(welcomePageContent.getName(), welcomePageContent.getTitle(), welcomePageContent.getMessage(), configuration, (List<Property<?>>)ImmutableList.of());
        this.welcomePageContent = welcomePageContent;
        this.headerFont = this.createHeaderFont();
    }

    private Font createHeaderFont() {
        FontData[] fontData;
        for (FontData font : fontData = JFaceResources.getDialogFont().getFontData()) {
            font.setHeight(18);
        }
        return new Font((Device)PlatformUI.getWorkbench().getDisplay(), fontData);
    }

    @Override
    protected void createWidgets(Composite root) {
        root.setLayout((Layout)new GridLayout(1, false));
        Composite container = new Composite(root, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout containerLayout = new GridLayout(1, false);
        containerLayout.marginRight = 50;
        containerLayout.marginLeft = 50;
        container.setLayout((Layout)containerLayout);
        StyledText welcomeText = new StyledText(container, 16777282);
        GridData welcomeTextLayoutData = new GridData(4, 128, true, false, 1, 1);
        welcomeTextLayoutData.widthHint = 500;
        welcomeText.setLayoutData((Object)welcomeTextLayoutData);
        welcomeText.setBackground(welcomeText.getParent().getBackground());
        welcomeText.setEnabled(false);
        welcomeText.setEditable(false);
        this.fillWelcomeText(welcomeText);
        final Button showWelcomePageCheckbox = new Button(container, 32);
        showWelcomePageCheckbox.setText(ProjectWizardMessages.CheckButton_ShowWelcomePageNextTime);
        GridData showWelcomePageCheckboxLayoutData = new GridData(16384, 0x1000000, false, false, 1, 1);
        showWelcomePageCheckboxLayoutData.widthHint = welcomeTextLayoutData.widthHint;
        showWelcomePageCheckboxLayoutData.verticalIndent = 15;
        showWelcomePageCheckbox.setLayoutData((Object)showWelcomePageCheckboxLayoutData);
        showWelcomePageCheckbox.setSelection(((AbstractProjectWizard)this.getWizard()).isShowWelcomePage());
        showWelcomePageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((AbstractProjectWizard)GradleWelcomeWizardPage.this.getWizard()).setWelcomePageEnabled(showWelcomePageCheckbox.getSelection());
            }
        });
    }

    private void fillWelcomeText(StyledText welcomeText) {
        StringBuilder welcomeContent = new StringBuilder();
        welcomeContent.append(this.welcomePageContent.getParagraphTitle());
        for (WelcomePageContent.PageParagraph paragraph : this.welcomePageContent.getParagraphs()) {
            welcomeContent.append(LINE_SEPARATOR);
            welcomeContent.append(LINE_SEPARATOR);
            welcomeContent.append(paragraph.getTitle());
            welcomeContent.append(paragraph.getContent());
        }
        welcomeText.setText(welcomeContent.toString());
        welcomeText.setLineJustify(1, welcomeText.getLineCount() - 1, true);
        this.setBoldTitle(welcomeText, this.welcomePageContent.getParagraphTitle(), this.headerFont);
        for (WelcomePageContent.PageParagraph welcomePageParagraph : this.welcomePageContent.getParagraphs()) {
            this.setBoldTitle(welcomeText, welcomePageParagraph.getTitle(), null);
        }
    }

    private void setBoldTitle(StyledText welcomeText, String title, Font font) {
        StyleRange titleStyle = new StyleRange();
        titleStyle.start = welcomeText.getText().indexOf(title);
        titleStyle.length = title.length();
        titleStyle.font = font;
        titleStyle.fontStyle = 1;
        welcomeText.setStyleRange(titleStyle);
    }

    @Override
    protected String getPageContextInformation() {
        return this.welcomePageContent.getPageContextInformation();
    }

    @Override
    public void dispose() {
        this.headerFont.dispose();
        super.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ((AbstractProjectWizard)this.getWizard()).setFinishGloballyEnabled(!visible);
    }
}

