/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.Cast;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.PluginIdentifier;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.StartEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationFinishEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationOperationDescriptor;
import org.gradle.tooling.events.configuration.ProjectConfigurationOperationResult;
import org.gradle.tooling.events.configuration.ProjectConfigurationProgressEvent;
import org.gradle.tooling.events.configuration.ProjectConfigurationStartEvent;
import org.gradle.tooling.events.configuration.internal.DefaultPluginApplicationResult;
import org.gradle.tooling.events.configuration.internal.DefaultProjectConfigurationFailureResult;
import org.gradle.tooling.events.configuration.internal.DefaultProjectConfigurationFinishEvent;
import org.gradle.tooling.events.configuration.internal.DefaultProjectConfigurationOperationDescriptor;
import org.gradle.tooling.events.configuration.internal.DefaultProjectConfigurationStartEvent;
import org.gradle.tooling.events.configuration.internal.DefaultProjectConfigurationSuccessResult;
import org.gradle.tooling.events.download.FileDownloadFinishEvent;
import org.gradle.tooling.events.download.FileDownloadOperationDescriptor;
import org.gradle.tooling.events.download.FileDownloadProgressEvent;
import org.gradle.tooling.events.download.FileDownloadResult;
import org.gradle.tooling.events.download.FileDownloadStartEvent;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadFailureResult;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadFinishEvent;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadOperationDescriptor;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadStartEvent;
import org.gradle.tooling.events.download.internal.DefaultFileDownloadSuccessResult;
import org.gradle.tooling.events.download.internal.NotFoundFileDownloadSuccessResult;
import org.gradle.tooling.events.internal.DefaultBinaryPluginIdentifier;
import org.gradle.tooling.events.internal.DefaultFinishEvent;
import org.gradle.tooling.events.internal.DefaultOperationDescriptor;
import org.gradle.tooling.events.internal.DefaultOperationFailureResult;
import org.gradle.tooling.events.internal.DefaultOperationSuccessResult;
import org.gradle.tooling.events.internal.DefaultScriptPluginIdentifier;
import org.gradle.tooling.events.internal.DefaultStartEvent;
import org.gradle.tooling.events.internal.DefaultStatusEvent;
import org.gradle.tooling.events.lifecycle.BuildPhaseFinishEvent;
import org.gradle.tooling.events.lifecycle.BuildPhaseOperationDescriptor;
import org.gradle.tooling.events.lifecycle.BuildPhaseProgressEvent;
import org.gradle.tooling.events.lifecycle.BuildPhaseStartEvent;
import org.gradle.tooling.events.lifecycle.internal.DefaultBuildPhaseFinishEvent;
import org.gradle.tooling.events.lifecycle.internal.DefaultBuildPhaseOperationDescriptor;
import org.gradle.tooling.events.lifecycle.internal.DefaultBuildPhaseStartEvent;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.gradle.tooling.events.task.TaskStartEvent;
import org.gradle.tooling.events.task.internal.DefaultTaskFailureResult;
import org.gradle.tooling.events.task.internal.DefaultTaskFinishEvent;
import org.gradle.tooling.events.task.internal.DefaultTaskOperationDescriptor;
import org.gradle.tooling.events.task.internal.DefaultTaskSkippedResult;
import org.gradle.tooling.events.task.internal.DefaultTaskStartEvent;
import org.gradle.tooling.events.task.internal.DefaultTaskSuccessResult;
import org.gradle.tooling.events.task.internal.TaskExecutionDetails;
import org.gradle.tooling.events.task.internal.java.DefaultAnnotationProcessorResult;
import org.gradle.tooling.events.task.internal.java.DefaultJavaCompileTaskSuccessResult;
import org.gradle.tooling.events.task.java.JavaCompileTaskOperationResult;
import org.gradle.tooling.events.test.Destination;
import org.gradle.tooling.events.test.JvmTestKind;
import org.gradle.tooling.events.test.TestFinishEvent;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.events.test.TestOperationResult;
import org.gradle.tooling.events.test.TestOutputDescriptor;
import org.gradle.tooling.events.test.TestOutputEvent;
import org.gradle.tooling.events.test.TestProgressEvent;
import org.gradle.tooling.events.test.TestStartEvent;
import org.gradle.tooling.events.test.internal.DefaultJvmTestOperationDescriptor;
import org.gradle.tooling.events.test.internal.DefaultTestFailureResult;
import org.gradle.tooling.events.test.internal.DefaultTestFinishEvent;
import org.gradle.tooling.events.test.internal.DefaultTestOperationDescriptor;
import org.gradle.tooling.events.test.internal.DefaultTestOutputEvent;
import org.gradle.tooling.events.test.internal.DefaultTestOutputOperationDescriptor;
import org.gradle.tooling.events.test.internal.DefaultTestSkippedResult;
import org.gradle.tooling.events.test.internal.DefaultTestStartEvent;
import org.gradle.tooling.events.test.internal.DefaultTestSuccessResult;
import org.gradle.tooling.events.transform.TransformFinishEvent;
import org.gradle.tooling.events.transform.TransformOperationDescriptor;
import org.gradle.tooling.events.transform.TransformOperationResult;
import org.gradle.tooling.events.transform.TransformProgressEvent;
import org.gradle.tooling.events.transform.TransformStartEvent;
import org.gradle.tooling.events.transform.internal.DefaultTransformFailureResult;
import org.gradle.tooling.events.transform.internal.DefaultTransformFinishEvent;
import org.gradle.tooling.events.transform.internal.DefaultTransformOperationDescriptor;
import org.gradle.tooling.events.transform.internal.DefaultTransformStartEvent;
import org.gradle.tooling.events.transform.internal.DefaultTransformSuccessResult;
import org.gradle.tooling.events.work.WorkItemFinishEvent;
import org.gradle.tooling.events.work.WorkItemOperationDescriptor;
import org.gradle.tooling.events.work.WorkItemOperationResult;
import org.gradle.tooling.events.work.WorkItemProgressEvent;
import org.gradle.tooling.events.work.WorkItemStartEvent;
import org.gradle.tooling.events.work.internal.DefaultWorkItemFailureResult;
import org.gradle.tooling.events.work.internal.DefaultWorkItemFinishEvent;
import org.gradle.tooling.events.work.internal.DefaultWorkItemOperationDescriptor;
import org.gradle.tooling.events.work.internal.DefaultWorkItemStartEvent;
import org.gradle.tooling.events.work.internal.DefaultWorkItemSuccessResult;
import org.gradle.tooling.internal.consumer.DefaultFailure;
import org.gradle.tooling.internal.consumer.DefaultTestAssertionFailure;
import org.gradle.tooling.internal.consumer.DefaultTestFrameworkFailure;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.tooling.internal.protocol.InternalFailure;
import org.gradle.tooling.internal.protocol.InternalTestAssertionFailure;
import org.gradle.tooling.internal.protocol.InternalTestFrameworkFailure;
import org.gradle.tooling.internal.protocol.events.InternalBinaryPluginIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalBuildPhaseDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalFailureResult;
import org.gradle.tooling.internal.protocol.events.InternalFileDownloadDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalFileDownloadResult;
import org.gradle.tooling.internal.protocol.events.InternalIncrementalTaskResult;
import org.gradle.tooling.internal.protocol.events.InternalJavaCompileTaskOperationResult;
import org.gradle.tooling.internal.protocol.events.InternalJvmTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalNotFoundFileDownloadResult;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationResult;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalPluginIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalProjectConfigurationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalProjectConfigurationResult;
import org.gradle.tooling.internal.protocol.events.InternalScriptPluginIdentifier;
import org.gradle.tooling.internal.protocol.events.InternalStatusEvent;
import org.gradle.tooling.internal.protocol.events.InternalSuccessResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskCachedResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTaskFailureResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskSkippedResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskSuccessResult;
import org.gradle.tooling.internal.protocol.events.InternalTaskWithExtraInfoDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestFailureResult;
import org.gradle.tooling.internal.protocol.events.InternalTestFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestOutputDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestOutputEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestResult;
import org.gradle.tooling.internal.protocol.events.InternalTestSkippedResult;
import org.gradle.tooling.internal.protocol.events.InternalTestStartedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestSuccessResult;
import org.gradle.tooling.internal.protocol.events.InternalTransformDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalWorkItemDescriptor;

public class BuildProgressListenerAdapter
implements InternalBuildProgressListener {
    private final ListenerBroadcast<ProgressListener> testProgressListeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> taskProgressListeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> buildOperationProgressListeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> workItemProgressListeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> projectConfigurationProgressListeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> transformProgressListeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> testOutputProgressListeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> fileDownloadListeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final ListenerBroadcast<ProgressListener> buildPhaseListeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final Map<Object, OperationDescriptor> descriptorCache = new HashMap<Object, OperationDescriptor>();

    BuildProgressListenerAdapter(Map<OperationType, List<ProgressListener>> listeners) {
        List noListeners = Collections.emptyList();
        this.testProgressListeners.addAll(listeners.getOrDefault((Object)OperationType.TEST, noListeners));
        this.taskProgressListeners.addAll(listeners.getOrDefault((Object)OperationType.TASK, noListeners));
        this.buildOperationProgressListeners.addAll(listeners.getOrDefault((Object)OperationType.GENERIC, noListeners));
        this.workItemProgressListeners.addAll(listeners.getOrDefault((Object)OperationType.WORK_ITEM, noListeners));
        this.projectConfigurationProgressListeners.addAll(listeners.getOrDefault((Object)OperationType.PROJECT_CONFIGURATION, noListeners));
        this.transformProgressListeners.addAll(listeners.getOrDefault((Object)OperationType.TRANSFORM, noListeners));
        this.testOutputProgressListeners.addAll(listeners.getOrDefault((Object)OperationType.TEST_OUTPUT, noListeners));
        this.fileDownloadListeners.addAll(listeners.getOrDefault((Object)OperationType.FILE_DOWNLOAD, noListeners));
        this.buildPhaseListeners.addAll(listeners.getOrDefault((Object)OperationType.BUILD_PHASE, noListeners));
    }

    @Override
    public List<String> getSubscribedOperations() {
        ArrayList<String> operations = new ArrayList<String>();
        if (!this.testProgressListeners.isEmpty()) {
            operations.add("TEST_EXECUTION");
        }
        if (!this.taskProgressListeners.isEmpty()) {
            operations.add("TASK_EXECUTION");
        }
        if (!this.buildOperationProgressListeners.isEmpty()) {
            operations.add("BUILD_EXECUTION");
        }
        if (!this.workItemProgressListeners.isEmpty()) {
            operations.add("WORK_ITEM_EXECUTION");
        }
        if (!this.projectConfigurationProgressListeners.isEmpty()) {
            operations.add("PROJECT_CONFIGURATION_EXECUTION");
        }
        if (!this.transformProgressListeners.isEmpty()) {
            operations.add("TRANSFORM_EXECUTION");
        }
        if (!this.testOutputProgressListeners.isEmpty()) {
            operations.add("TEST_OUTPUT");
        }
        if (!this.fileDownloadListeners.isEmpty()) {
            operations.add("FILE_DOWNLOAD");
        }
        if (!this.buildPhaseListeners.isEmpty()) {
            operations.add("BUILD_PHASE");
        }
        return operations;
    }

    @Override
    public void onEvent(Object event) {
        if (event instanceof ProgressEvent) {
            this.broadcastProgressEvent((ProgressEvent)event);
        } else if (event instanceof InternalTestProgressEvent) {
            this.broadcastTestProgressEvent((InternalTestProgressEvent)event);
        } else if (event instanceof InternalProgressEvent) {
            this.broadcastInternalProgressEvent((InternalProgressEvent)event);
        } else {
            throw new IllegalArgumentException("Unexpected event type: " + event);
        }
    }

    private void broadcastProgressEvent(ProgressEvent event) {
        if (event instanceof TestProgressEvent) {
            this.testProgressListeners.getSource().statusChanged(event);
        } else if (event instanceof TaskProgressEvent) {
            this.taskProgressListeners.getSource().statusChanged(event);
        } else if (event instanceof WorkItemProgressEvent) {
            this.workItemProgressListeners.getSource().statusChanged(event);
        } else if (event instanceof ProjectConfigurationProgressEvent) {
            this.projectConfigurationProgressListeners.getSource().statusChanged(event);
        } else if (event instanceof TransformProgressEvent) {
            this.transformProgressListeners.getSource().statusChanged(event);
        } else if (event instanceof TestOutputEvent) {
            this.testOutputProgressListeners.getSource().statusChanged(event);
        } else if (event instanceof BuildPhaseProgressEvent) {
            this.buildPhaseListeners.getSource().statusChanged(event);
        } else {
            this.buildOperationProgressListeners.getSource().statusChanged(event);
        }
    }

    private void broadcastTestProgressEvent(InternalTestProgressEvent event) {
        TestProgressEvent testProgressEvent = this.toTestProgressEvent(event);
        if (testProgressEvent != null) {
            this.testProgressListeners.getSource().statusChanged(testProgressEvent);
        }
    }

    private void broadcastInternalProgressEvent(InternalProgressEvent progressEvent) {
        InternalOperationDescriptor descriptor = progressEvent.getDescriptor();
        if (descriptor instanceof InternalTaskDescriptor) {
            this.broadcastTaskProgressEvent(progressEvent, (InternalTaskDescriptor)descriptor);
        } else if (descriptor instanceof InternalWorkItemDescriptor) {
            this.broadcastWorkItemProgressEvent(progressEvent, (InternalWorkItemDescriptor)descriptor);
        } else if (descriptor instanceof InternalProjectConfigurationDescriptor) {
            this.broadcastProjectConfigurationProgressEvent(progressEvent, (InternalProjectConfigurationDescriptor)descriptor);
        } else if (descriptor instanceof InternalTransformDescriptor) {
            this.broadcastTransformProgressEvent(progressEvent, (InternalTransformDescriptor)descriptor);
        } else if (descriptor instanceof InternalTestOutputDescriptor) {
            this.broadcastTestOutputEvent(progressEvent, (InternalTestOutputDescriptor)descriptor);
        } else if (progressEvent instanceof InternalStatusEvent) {
            this.broadcastStatusEvent((InternalStatusEvent)progressEvent);
        } else if (descriptor instanceof InternalFileDownloadDescriptor) {
            this.broadcastFileDownloadEvent(progressEvent, (InternalFileDownloadDescriptor)descriptor);
        } else if (descriptor instanceof InternalBuildPhaseDescriptor) {
            this.broadcastBuildPhaseEvent(progressEvent, (InternalBuildPhaseDescriptor)descriptor);
        } else {
            this.broadcastGenericProgressEvent(progressEvent);
        }
    }

    private void broadcastStatusEvent(InternalStatusEvent progressEvent) {
        OperationDescriptor descriptor = this.descriptorCache.get(progressEvent.getDescriptor().getId());
        if (descriptor == null) {
            throw new IllegalStateException(String.format("No operation with id %s in progress.", progressEvent.getDescriptor().getId()));
        }
        this.fileDownloadListeners.getSource().statusChanged(new DefaultStatusEvent(progressEvent.getEventTime(), descriptor, progressEvent.getTotal(), progressEvent.getProgress(), progressEvent.getUnits()));
    }

    private void broadcastTaskProgressEvent(InternalProgressEvent event, InternalTaskDescriptor descriptor) {
        TaskProgressEvent taskProgressEvent = this.toTaskProgressEvent(event, descriptor);
        if (taskProgressEvent != null) {
            this.taskProgressListeners.getSource().statusChanged(taskProgressEvent);
        }
    }

    private void broadcastWorkItemProgressEvent(InternalProgressEvent event, InternalWorkItemDescriptor descriptor) {
        WorkItemProgressEvent workItemProgressEvent = this.toWorkItemProgressEvent(event, descriptor);
        if (workItemProgressEvent != null) {
            this.workItemProgressListeners.getSource().statusChanged(workItemProgressEvent);
        }
    }

    private void broadcastProjectConfigurationProgressEvent(InternalProgressEvent event, InternalProjectConfigurationDescriptor descriptor) {
        ProjectConfigurationProgressEvent projectConfigurationProgressEvent = this.toProjectConfigurationProgressEvent(event, descriptor);
        if (projectConfigurationProgressEvent != null) {
            this.projectConfigurationProgressListeners.getSource().statusChanged(projectConfigurationProgressEvent);
        }
    }

    private void broadcastTransformProgressEvent(InternalProgressEvent event, InternalTransformDescriptor descriptor) {
        TransformProgressEvent transformProgressEvent = this.toTransformProgressEvent(event, descriptor);
        if (transformProgressEvent != null) {
            this.transformProgressListeners.getSource().statusChanged(transformProgressEvent);
        }
    }

    private void broadcastTestOutputEvent(InternalProgressEvent event, InternalTestOutputDescriptor descriptor) {
        TestOutputEvent outputEvent = this.toTestOutputEvent(event, descriptor);
        if (outputEvent != null) {
            this.testOutputProgressListeners.getSource().statusChanged(outputEvent);
        }
    }

    private void broadcastFileDownloadEvent(InternalProgressEvent event, InternalFileDownloadDescriptor descriptor) {
        FileDownloadProgressEvent progressEvent = this.toFileDownloadProgressEvent(event, descriptor);
        if (progressEvent != null) {
            this.fileDownloadListeners.getSource().statusChanged(progressEvent);
        }
    }

    private void broadcastBuildPhaseEvent(InternalProgressEvent event, InternalBuildPhaseDescriptor descriptor) {
        BuildPhaseProgressEvent progressEvent = this.toBuildPhaseEvent(event, descriptor);
        if (progressEvent != null) {
            this.buildPhaseListeners.getSource().statusChanged(progressEvent);
        }
    }

    private BuildPhaseProgressEvent toBuildPhaseEvent(InternalProgressEvent event, InternalBuildPhaseDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.buildPhaseStartEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.buildPhaseFinishEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private BuildPhaseStartEvent buildPhaseStartEvent(InternalOperationStartedProgressEvent event, InternalBuildPhaseDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        BuildPhaseOperationDescriptor newDescriptor = this.addDescriptor(event.getDescriptor(), new DefaultBuildPhaseOperationDescriptor(descriptor, parent));
        return new DefaultBuildPhaseStartEvent(event.getEventTime(), event.getDisplayName(), newDescriptor);
    }

    private BuildPhaseFinishEvent buildPhaseFinishEvent(InternalOperationFinishedProgressEvent event) {
        OperationResult result;
        BuildPhaseOperationDescriptor descriptor = this.removeDescriptor(BuildPhaseOperationDescriptor.class, event.getDescriptor());
        if (event.getResult() instanceof InternalFailureResult) {
            InternalFailureResult internalResult = (InternalFailureResult)event.getResult();
            result = new DefaultOperationFailureResult(internalResult.getStartTime(), internalResult.getEndTime(), BuildProgressListenerAdapter.toFailures(internalResult.getFailures()));
        } else {
            result = new DefaultOperationSuccessResult(event.getResult().getStartTime(), event.getResult().getEndTime());
        }
        return new DefaultBuildPhaseFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, result);
    }

    private void broadcastGenericProgressEvent(InternalProgressEvent event) {
        ProgressEvent progressEvent = this.toGenericProgressEvent(event);
        if (progressEvent != null) {
            this.buildOperationProgressListeners.getSource().statusChanged(progressEvent);
        }
    }

    private TestProgressEvent toTestProgressEvent(InternalTestProgressEvent event) {
        if (event instanceof InternalTestStartedProgressEvent) {
            return this.testStartedEvent((InternalTestStartedProgressEvent)event);
        }
        if (event instanceof InternalTestFinishedProgressEvent) {
            return this.testFinishedEvent((InternalTestFinishedProgressEvent)event);
        }
        return null;
    }

    private TaskProgressEvent toTaskProgressEvent(InternalProgressEvent event, InternalTaskDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.taskStartedEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.taskFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private WorkItemProgressEvent toWorkItemProgressEvent(InternalProgressEvent event, InternalWorkItemDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.workItemStartedEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.workItemFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private ProjectConfigurationProgressEvent toProjectConfigurationProgressEvent(InternalProgressEvent event, InternalProjectConfigurationDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.projectConfigurationStartedEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.projectConfigurationFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private TransformProgressEvent toTransformProgressEvent(InternalProgressEvent event, InternalTransformDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.transformStartedEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.transformFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private FileDownloadProgressEvent toFileDownloadProgressEvent(InternalProgressEvent event, InternalFileDownloadDescriptor descriptor) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.fileDownloadStartEvent((InternalOperationStartedProgressEvent)event, descriptor);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.fileDownloadFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private TestOutputEvent toTestOutputEvent(InternalProgressEvent event, InternalTestOutputDescriptor descriptor) {
        if (event instanceof InternalTestOutputEvent) {
            return this.transformTestOutput((InternalTestOutputEvent)event, descriptor);
        }
        return null;
    }

    private ProgressEvent toGenericProgressEvent(InternalProgressEvent event) {
        if (event instanceof InternalOperationStartedProgressEvent) {
            return this.genericStartedEvent((InternalOperationStartedProgressEvent)event);
        }
        if (event instanceof InternalOperationFinishedProgressEvent) {
            return this.genericFinishedEvent((InternalOperationFinishedProgressEvent)event);
        }
        return null;
    }

    private TestStartEvent testStartedEvent(InternalTestStartedProgressEvent event) {
        TestOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toTestDescriptor(event.getDescriptor()));
        return new DefaultTestStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private TaskStartEvent taskStartedEvent(InternalOperationStartedProgressEvent event, InternalTaskDescriptor descriptor) {
        TaskOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toTaskDescriptor(descriptor));
        return new DefaultTaskStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private WorkItemStartEvent workItemStartedEvent(InternalOperationStartedProgressEvent event, InternalWorkItemDescriptor descriptor) {
        WorkItemOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toWorkItemDescriptor(descriptor));
        return new DefaultWorkItemStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private ProjectConfigurationStartEvent projectConfigurationStartedEvent(InternalOperationStartedProgressEvent event, InternalProjectConfigurationDescriptor descriptor) {
        ProjectConfigurationOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toProjectConfigurationDescriptor(descriptor));
        return new DefaultProjectConfigurationStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private TransformStartEvent transformStartedEvent(InternalOperationStartedProgressEvent event, InternalTransformDescriptor descriptor) {
        TransformOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toTransformDescriptor(descriptor));
        return new DefaultTransformStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private TestOutputEvent transformTestOutput(InternalTestOutputEvent event, InternalTestOutputDescriptor descriptor) {
        TestOutputDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toTestOutputDescriptor(event, descriptor));
        return new DefaultTestOutputEvent(event.getEventTime(), clientDescriptor);
    }

    private FileDownloadStartEvent fileDownloadStartEvent(InternalOperationStartedProgressEvent event, InternalFileDownloadDescriptor descriptor) {
        FileDownloadOperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toFileDownloadDescriptor(descriptor));
        return new DefaultFileDownloadStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private StartEvent genericStartedEvent(InternalOperationStartedProgressEvent event) {
        OperationDescriptor clientDescriptor = this.addDescriptor(event.getDescriptor(), this.toDescriptor(event.getDescriptor()));
        return new DefaultStartEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor);
    }

    private TestFinishEvent testFinishedEvent(InternalTestFinishedProgressEvent event) {
        TestOperationDescriptor clientDescriptor = this.removeDescriptor(TestOperationDescriptor.class, event.getDescriptor());
        return new DefaultTestFinishEvent(event.getEventTime(), event.getDisplayName(), clientDescriptor, this.toTestResult(event.getResult()));
    }

    private TaskFinishEvent taskFinishedEvent(InternalOperationFinishedProgressEvent event) {
        TaskOperationDescriptor descriptor = this.assertDescriptorType(TaskOperationDescriptor.class, this.getParentDescriptor(event.getDescriptor().getId()));
        return new DefaultTaskFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toTaskResult((InternalTaskResult)event.getResult()));
    }

    private WorkItemFinishEvent workItemFinishedEvent(InternalOperationFinishedProgressEvent event) {
        WorkItemOperationDescriptor descriptor = this.removeDescriptor(WorkItemOperationDescriptor.class, event.getDescriptor());
        return new DefaultWorkItemFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toWorkItemResult(event.getResult()));
    }

    private ProjectConfigurationFinishEvent projectConfigurationFinishedEvent(InternalOperationFinishedProgressEvent event) {
        ProjectConfigurationOperationDescriptor descriptor = this.removeDescriptor(ProjectConfigurationOperationDescriptor.class, event.getDescriptor());
        return new DefaultProjectConfigurationFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toProjectConfigurationResult((InternalProjectConfigurationResult)event.getResult()));
    }

    private TransformFinishEvent transformFinishedEvent(InternalOperationFinishedProgressEvent event) {
        TransformOperationDescriptor descriptor = this.assertDescriptorType(TransformOperationDescriptor.class, this.getParentDescriptor(event.getDescriptor().getId()));
        return new DefaultTransformFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toTransformResult(event.getResult()));
    }

    private FileDownloadFinishEvent fileDownloadFinishedEvent(InternalOperationFinishedProgressEvent event) {
        FileDownloadOperationDescriptor descriptor = this.removeDescriptor(FileDownloadOperationDescriptor.class, event.getDescriptor());
        return new DefaultFileDownloadFinishEvent(event.getEventTime(), event.getDisplayName(), descriptor, this.toFileDownloadResult(event.getResult()));
    }

    private FinishEvent genericFinishedEvent(InternalOperationFinishedProgressEvent event) {
        OperationDescriptor descriptor = this.removeDescriptor(OperationDescriptor.class, event.getDescriptor());
        return new DefaultFinishEvent<OperationDescriptor, OperationResult>(event.getEventTime(), event.getDisplayName(), descriptor, BuildProgressListenerAdapter.toResult(event.getResult()));
    }

    private synchronized <T extends OperationDescriptor> T addDescriptor(InternalOperationDescriptor descriptor, T clientDescriptor) {
        if (this.descriptorCache.containsKey(descriptor.getId())) {
            throw new IllegalStateException(String.format("Operation %s already available.", descriptor));
        }
        this.descriptorCache.put(descriptor.getId(), clientDescriptor);
        return clientDescriptor;
    }

    private synchronized <T extends OperationDescriptor> T removeDescriptor(Class<T> type, InternalOperationDescriptor descriptor) {
        OperationDescriptor cachedTestDescriptor = this.descriptorCache.remove(descriptor.getId());
        if (cachedTestDescriptor == null) {
            throw new IllegalStateException(String.format("Operation %s is not available.", descriptor));
        }
        return this.assertDescriptorType(type, cachedTestDescriptor);
    }

    private <T extends OperationDescriptor> T assertDescriptorType(Class<T> type, OperationDescriptor descriptor) {
        Class<?> descriptorClass = descriptor.getClass();
        if (!type.isAssignableFrom(descriptorClass)) {
            throw new IllegalStateException(String.format("Unexpected operation type. Required %s but found %s", type.getName(), descriptorClass.getName()));
        }
        return (T)((OperationDescriptor)Cast.uncheckedNonnullCast(descriptor));
    }

    private TestOperationDescriptor toTestDescriptor(InternalTestDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        if (descriptor instanceof InternalJvmTestDescriptor) {
            InternalJvmTestDescriptor jvmTestDescriptor = (InternalJvmTestDescriptor)descriptor;
            return new DefaultJvmTestOperationDescriptor(jvmTestDescriptor, parent, BuildProgressListenerAdapter.toJvmTestKind(jvmTestDescriptor.getTestKind()), jvmTestDescriptor.getSuiteName(), jvmTestDescriptor.getClassName(), jvmTestDescriptor.getMethodName());
        }
        return new DefaultTestOperationDescriptor(descriptor, parent);
    }

    private static JvmTestKind toJvmTestKind(String testKind) {
        if ("SUITE".equals(testKind)) {
            return JvmTestKind.SUITE;
        }
        if ("ATOMIC".equals(testKind)) {
            return JvmTestKind.ATOMIC;
        }
        return JvmTestKind.UNKNOWN;
    }

    private TaskOperationDescriptor toTaskDescriptor(InternalTaskDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        if (descriptor instanceof InternalTaskWithExtraInfoDescriptor) {
            InternalTaskWithExtraInfoDescriptor descriptorWithExtras = (InternalTaskWithExtraInfoDescriptor)descriptor;
            Set<OperationDescriptor> dependencies = this.collectDescriptors(descriptorWithExtras.getDependencies());
            PluginIdentifier originPlugin = BuildProgressListenerAdapter.toPluginIdentifier(descriptorWithExtras.getOriginPlugin());
            return new DefaultTaskOperationDescriptor(descriptor, parent, descriptor.getTaskPath(), dependencies, originPlugin);
        }
        return new DefaultTaskOperationDescriptor(descriptor, parent, descriptor.getTaskPath());
    }

    private WorkItemOperationDescriptor toWorkItemDescriptor(InternalWorkItemDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultWorkItemOperationDescriptor(descriptor, parent);
    }

    private ProjectConfigurationOperationDescriptor toProjectConfigurationDescriptor(InternalProjectConfigurationDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultProjectConfigurationOperationDescriptor(descriptor, parent);
    }

    private TransformOperationDescriptor toTransformDescriptor(InternalTransformDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultTransformOperationDescriptor(descriptor, parent, this.collectDescriptors(descriptor.getDependencies()));
    }

    private FileDownloadOperationDescriptor toFileDownloadDescriptor(InternalFileDownloadDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultFileDownloadOperationDescriptor(descriptor, parent);
    }

    private TestOutputDescriptor toTestOutputDescriptor(InternalTestOutputEvent event, InternalTestOutputDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        Destination destination = Destination.fromCode(event.getResult().getDestination());
        String message = event.getResult().getMessage();
        return new DefaultTestOutputOperationDescriptor(descriptor, parent, destination, message);
    }

    private Set<OperationDescriptor> collectDescriptors(Set<? extends InternalOperationDescriptor> dependencies) {
        LinkedHashSet<OperationDescriptor> result = new LinkedHashSet<OperationDescriptor>();
        for (InternalOperationDescriptor internalOperationDescriptor : dependencies) {
            OperationDescriptor dependencyDescriptor = this.descriptorCache.get(internalOperationDescriptor.getId());
            if (dependencyDescriptor == null) continue;
            result.add(dependencyDescriptor);
        }
        return result;
    }

    private OperationDescriptor toDescriptor(InternalOperationDescriptor descriptor) {
        OperationDescriptor parent = this.getParentDescriptor(descriptor.getParentId());
        return new DefaultOperationDescriptor(descriptor, parent);
    }

    private synchronized OperationDescriptor getParentDescriptor(Object parentId) {
        if (parentId == null) {
            return null;
        }
        OperationDescriptor operationDescriptor = this.descriptorCache.get(parentId);
        if (operationDescriptor == null) {
            throw new IllegalStateException(String.format("Parent operation with id %s not available.", parentId));
        }
        return operationDescriptor;
    }

    private FileDownloadResult toFileDownloadResult(InternalOperationResult result) {
        InternalFileDownloadResult fileDownloadResult = (InternalFileDownloadResult)((Object)result);
        if (result instanceof InternalNotFoundFileDownloadResult) {
            return new NotFoundFileDownloadSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalSuccessResult) {
            return new DefaultFileDownloadSuccessResult(result.getStartTime(), result.getEndTime(), fileDownloadResult.getBytesDownloaded());
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultFileDownloadFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()), fileDownloadResult.getBytesDownloaded());
        }
        return null;
    }

    private TestOperationResult toTestResult(InternalTestResult result) {
        if (result instanceof InternalTestSuccessResult) {
            return new DefaultTestSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalTestSkippedResult) {
            return new DefaultTestSkippedResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalTestFailureResult) {
            return new DefaultTestFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    public static TaskOperationResult toTaskResult(InternalTaskResult result) {
        if (result instanceof InternalTaskSuccessResult) {
            InternalTaskSuccessResult successResult = (InternalTaskSuccessResult)result;
            if (result instanceof InternalJavaCompileTaskOperationResult) {
                List<JavaCompileTaskOperationResult.AnnotationProcessorResult> annotationProcessorResults = BuildProgressListenerAdapter.toAnnotationProcessorResults(((InternalJavaCompileTaskOperationResult)result).getAnnotationProcessorResults());
                return new DefaultJavaCompileTaskSuccessResult(result.getStartTime(), result.getEndTime(), successResult.isUpToDate(), BuildProgressListenerAdapter.isFromCache(result), BuildProgressListenerAdapter.toTaskExecutionDetails(result), annotationProcessorResults);
            }
            return new DefaultTaskSuccessResult(result.getStartTime(), result.getEndTime(), successResult.isUpToDate(), BuildProgressListenerAdapter.isFromCache(result), BuildProgressListenerAdapter.toTaskExecutionDetails(result));
        }
        if (result instanceof InternalTaskSkippedResult) {
            return new DefaultTaskSkippedResult(result.getStartTime(), result.getEndTime(), ((InternalTaskSkippedResult)result).getSkipMessage());
        }
        if (result instanceof InternalTaskFailureResult) {
            return new DefaultTaskFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()), BuildProgressListenerAdapter.toTaskExecutionDetails(result));
        }
        return null;
    }

    private static boolean isFromCache(InternalTaskResult result) {
        if (result instanceof InternalTaskCachedResult) {
            return ((InternalTaskCachedResult)result).isFromCache();
        }
        return false;
    }

    private static TaskExecutionDetails toTaskExecutionDetails(InternalTaskResult result) {
        if (result instanceof InternalIncrementalTaskResult) {
            InternalIncrementalTaskResult taskResult = (InternalIncrementalTaskResult)result;
            return TaskExecutionDetails.of(taskResult.isIncremental(), taskResult.getExecutionReasons());
        }
        return TaskExecutionDetails.unsupported();
    }

    private static WorkItemOperationResult toWorkItemResult(InternalOperationResult result) {
        if (result instanceof InternalSuccessResult) {
            return new DefaultWorkItemSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultWorkItemFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    private static ProjectConfigurationOperationResult toProjectConfigurationResult(InternalProjectConfigurationResult result) {
        if (result instanceof InternalSuccessResult) {
            return new DefaultProjectConfigurationSuccessResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toPluginApplicationResults(result.getPluginApplicationResults()));
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultProjectConfigurationFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()), BuildProgressListenerAdapter.toPluginApplicationResults(result.getPluginApplicationResults()));
        }
        return null;
    }

    private static List<? extends ProjectConfigurationOperationResult.PluginApplicationResult> toPluginApplicationResults(List<? extends InternalProjectConfigurationResult.InternalPluginApplicationResult> pluginApplicationResults) {
        ArrayList<DefaultPluginApplicationResult> results = new ArrayList<DefaultPluginApplicationResult>();
        for (InternalProjectConfigurationResult.InternalPluginApplicationResult internalPluginApplicationResult : pluginApplicationResults) {
            PluginIdentifier plugin = BuildProgressListenerAdapter.toPluginIdentifier(internalPluginApplicationResult.getPlugin());
            if (plugin == null) continue;
            results.add(new DefaultPluginApplicationResult(plugin, internalPluginApplicationResult.getTotalConfigurationTime()));
        }
        return results;
    }

    private static PluginIdentifier toPluginIdentifier(InternalPluginIdentifier pluginIdentifier) {
        if (pluginIdentifier instanceof InternalBinaryPluginIdentifier) {
            InternalBinaryPluginIdentifier binaryPlugin = (InternalBinaryPluginIdentifier)pluginIdentifier;
            return new DefaultBinaryPluginIdentifier(binaryPlugin.getDisplayName(), binaryPlugin.getClassName(), binaryPlugin.getPluginId());
        }
        if (pluginIdentifier instanceof InternalScriptPluginIdentifier) {
            InternalScriptPluginIdentifier scriptPlugin = (InternalScriptPluginIdentifier)pluginIdentifier;
            return new DefaultScriptPluginIdentifier(scriptPlugin.getDisplayName(), scriptPlugin.getUri());
        }
        return null;
    }

    private static TransformOperationResult toTransformResult(InternalOperationResult result) {
        if (result instanceof InternalSuccessResult) {
            return new DefaultTransformSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultTransformFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    private static OperationResult toResult(InternalOperationResult result) {
        if (result instanceof InternalSuccessResult) {
            return new DefaultOperationSuccessResult(result.getStartTime(), result.getEndTime());
        }
        if (result instanceof InternalFailureResult) {
            return new DefaultOperationFailureResult(result.getStartTime(), result.getEndTime(), BuildProgressListenerAdapter.toFailures(result.getFailures()));
        }
        return null;
    }

    private static List<Failure> toFailures(List<? extends InternalFailure> causes) {
        if (causes == null) {
            return null;
        }
        ArrayList<Failure> failures = new ArrayList<Failure>();
        for (InternalFailure internalFailure : causes) {
            failures.add(BuildProgressListenerAdapter.toFailure(internalFailure));
        }
        return failures;
    }

    private static Failure toFailure(InternalFailure origFailure) {
        if (origFailure instanceof InternalTestAssertionFailure) {
            InternalTestAssertionFailure assertionFailure = (InternalTestAssertionFailure)origFailure;
            return new DefaultTestAssertionFailure(assertionFailure.getMessage(), assertionFailure.getDescription(), assertionFailure.getExpected(), assertionFailure.getActual(), BuildProgressListenerAdapter.toFailures(origFailure.getCauses()), ((InternalTestAssertionFailure)origFailure).getClassName(), ((InternalTestAssertionFailure)origFailure).getStacktrace());
        }
        if (origFailure instanceof InternalTestFrameworkFailure) {
            InternalTestFrameworkFailure frameworkFailure = (InternalTestFrameworkFailure)origFailure;
            return new DefaultTestFrameworkFailure(frameworkFailure.getMessage(), frameworkFailure.getDescription(), BuildProgressListenerAdapter.toFailures(origFailure.getCauses()), ((InternalTestFrameworkFailure)origFailure).getClassName(), ((InternalTestFrameworkFailure)origFailure).getStacktrace());
        }
        return origFailure == null ? null : new DefaultFailure(origFailure.getMessage(), origFailure.getDescription(), BuildProgressListenerAdapter.toFailures(origFailure.getCauses()));
    }

    private static List<JavaCompileTaskOperationResult.AnnotationProcessorResult> toAnnotationProcessorResults(List<InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult> protocolResults) {
        if (protocolResults == null) {
            return null;
        }
        ArrayList<JavaCompileTaskOperationResult.AnnotationProcessorResult> results = new ArrayList<JavaCompileTaskOperationResult.AnnotationProcessorResult>();
        for (InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult result : protocolResults) {
            results.add(BuildProgressListenerAdapter.toAnnotationProcessorResult(result));
        }
        return results;
    }

    private static JavaCompileTaskOperationResult.AnnotationProcessorResult toAnnotationProcessorResult(InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult result) {
        return new DefaultAnnotationProcessorResult(result.getClassName(), BuildProgressListenerAdapter.toAnnotationProcessorResultType(result.getType()), result.getDuration());
    }

    private static JavaCompileTaskOperationResult.AnnotationProcessorResult.Type toAnnotationProcessorResultType(String type) {
        if (type.equals("AGGREGATING")) {
            return JavaCompileTaskOperationResult.AnnotationProcessorResult.Type.AGGREGATING;
        }
        if (type.equals("ISOLATING")) {
            return JavaCompileTaskOperationResult.AnnotationProcessorResult.Type.ISOLATING;
        }
        return JavaCompileTaskOperationResult.AnnotationProcessorResult.Type.UNKNOWN;
    }
}

