/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCompatibilityMapping
implements Action<SourceObjectMapping>,
Serializable {
    final List<Action<SourceObjectMapping>> mappings;

    public static Builder builder() {
        return new Builder();
    }

    private CompositeCompatibilityMapping(List<Action<SourceObjectMapping>> mappings) {
        this.mappings = ImmutableList.copyOf(mappings);
    }

    @Override
    public void execute(SourceObjectMapping sourceObjectMapping) {
        for (Action<SourceObjectMapping> mapping : this.mappings) {
            mapping.execute(sourceObjectMapping);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final List<Action<SourceObjectMapping>> mappings = new ArrayList<Action<SourceObjectMapping>>();

        public Builder add(Action<SourceObjectMapping> mapping) {
            this.mappings.add(mapping);
            return this;
        }

        public CompositeCompatibilityMapping build() {
            for (Action<SourceObjectMapping> mapping : this.mappings) {
                if (mapping instanceof Serializable) continue;
                throw new IllegalArgumentException(String.format("Source object mapping '%s' must be serializable", mapping));
            }
            return new CompositeCompatibilityMapping(this.mappings);
        }
    }
}

