/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectDependency;
import com.gradleware.tooling.toolingmodel.OmniExternalDependency;
import java.util.List;
import org.eclipse.buildship.core.gradle.Specs;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class ClasspathContainerUpdater {
    private final IJavaProject eclipseProject;
    private final OmniEclipseProject gradleProject;

    private ClasspathContainerUpdater(IJavaProject eclipseProject, OmniEclipseProject gradleProject) {
        this.eclipseProject = (IJavaProject)Preconditions.checkNotNull((Object)eclipseProject);
        this.gradleProject = (OmniEclipseProject)Preconditions.checkNotNull((Object)gradleProject);
    }

    private void updateClasspathContainer(IProgressMonitor monitor) throws JavaModelException {
        ImmutableList<IClasspathEntry> containerEntries = this.collectClasspathContainerEntries();
        this.setClasspathContainer((List<IClasspathEntry>)containerEntries, monitor);
    }

    private ImmutableList<IClasspathEntry> collectClasspathContainerEntries() {
        ImmutableList projectDependencies = FluentIterable.from((Iterable)this.gradleProject.getProjectDependencies()).transform((Function)new Function<OmniEclipseProjectDependency, IClasspathEntry>(){

            public IClasspathEntry apply(OmniEclipseProjectDependency dependency) {
                OmniEclipseProject dependentProject = (OmniEclipseProject)ClasspathContainerUpdater.this.gradleProject.getRoot().tryFind(Specs.eclipseProjectMatchesProjectPath(dependency.getTargetProjectPath())).get();
                Path path = new Path("/" + dependentProject.getName());
                return JavaCore.newProjectEntry((IPath)path, (boolean)dependency.isExported());
            }
        }).toList();
        ImmutableList externalDependencies = FluentIterable.from((Iterable)this.gradleProject.getExternalDependencies()).filter((Predicate)new Predicate<OmniExternalDependency>(){

            public boolean apply(OmniExternalDependency dependency) {
                String name = dependency.getFile().getName();
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        }).transform((Function)new Function<OmniExternalDependency, IClasspathEntry>(){

            public IClasspathEntry apply(OmniExternalDependency dependency) {
                IPath jar = Path.fromOSString((String)dependency.getFile().getAbsolutePath());
                IPath sourceJar = dependency.getSource() != null ? Path.fromOSString((String)dependency.getSource().getAbsolutePath()) : null;
                return JavaCore.newLibraryEntry((IPath)jar, (IPath)sourceJar, null, (boolean)dependency.isExported());
            }
        }).toList();
        return ImmutableList.builder().addAll((Iterable)externalDependencies).addAll((Iterable)projectDependencies).build();
    }

    private void setClasspathContainer(List<IClasspathEntry> classpathEntries, IProgressMonitor monitor) throws JavaModelException {
        IClasspathContainer classpathContainer = GradleClasspathContainer.newInstance(classpathEntries);
        JavaCore.setClasspathContainer((IPath)ClasspathContainerUpdater.createContainerPath(), (IJavaProject[])new IJavaProject[]{this.eclipseProject}, (IClasspathContainer[])new IClasspathContainer[]{classpathContainer}, (IProgressMonitor)monitor);
    }

    public static void update(IJavaProject eclipseProject, OmniEclipseProject gradleProject, IProgressMonitor monitor) throws JavaModelException {
        ClasspathContainerUpdater updater = new ClasspathContainerUpdater(eclipseProject, gradleProject);
        updater.updateClasspathContainer(monitor);
    }

    public static void clear(IJavaProject eclipseProject, IProgressMonitor monitor) throws JavaModelException {
        IClasspathContainer classpathContainer = GradleClasspathContainer.newInstance((List<IClasspathEntry>)ImmutableList.of());
        JavaCore.setClasspathContainer((IPath)ClasspathContainerUpdater.createContainerPath(), (IJavaProject[])new IJavaProject[]{eclipseProject}, (IClasspathContainer[])new IClasspathContainer[]{classpathContainer}, (IProgressMonitor)monitor);
    }

    private static Path createContainerPath() {
        return new Path("org.eclipse.buildship.core.gradleclasspathcontainer");
    }
}

