/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.gradleware.tooling.toolingclient.BuildLaunchRequest;
import com.gradleware.tooling.toolingclient.BuildRequest;
import com.gradleware.tooling.toolingclient.LaunchableConfig;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.util.Pair;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.projectimport.ProjectPreviewJob;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.gradle.PublishedGradleVersionsWrapper;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.wizard.project.AbstractProjectWizard;
import org.eclipse.buildship.ui.wizard.project.GradleOptionsWizardPage;
import org.eclipse.buildship.ui.wizard.project.GradleWelcomeWizardPage;
import org.eclipse.buildship.ui.wizard.project.NewGradleProjectWizardPage;
import org.eclipse.buildship.ui.wizard.project.ProjectCreationConfiguration;
import org.eclipse.buildship.ui.wizard.project.ProjectCreationWizardController;
import org.eclipse.buildship.ui.wizard.project.ProjectImportWizardController;
import org.eclipse.buildship.ui.wizard.project.ProjectPreviewWizardPage;
import org.eclipse.buildship.ui.wizard.project.ProjectWizardMessages;
import org.eclipse.buildship.ui.wizard.project.WelcomePageContent;
import org.eclipse.buildship.ui.wizard.project.WelcomePageContentFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.ProgressListener;

public final class ProjectCreationWizard
extends AbstractProjectWizard
implements INewWizard {
    private static final String PROJECT_CREATION_DIALOG_SETTINGS = "org.eclipse.buildship.ui.wizard.project.creation";
    private static final String PREF_SHOW_WELCOME_PAGE = "org.eclipse.buildship.ui.wizard.project.creation.showWelcomePage";
    private static final ImmutableList<String> GRADLE_INIT_TASK_CMD_LINE = ImmutableList.of((Object)"init", (Object)"--type", (Object)"java-library");
    private final GradleWelcomeWizardPage welcomeWizardPage;
    private final NewGradleProjectWizardPage newGradleProjectPage;
    private final GradleOptionsWizardPage gradleOptionsPage;
    private final ProjectPreviewWizardPage projectPreviewPage;
    private final ProjectImportWizardController importController;
    private final ProjectCreationWizardController creationController;
    private final IPageChangedListener pageChangeListener;

    public ProjectCreationWizard() {
        this(ProjectCreationWizard.getOrCreateDialogSection(UiPlugin.getInstance().getDialogSettings()), CorePlugin.publishedGradleVersions());
    }

    public ProjectCreationWizard(IDialogSettings dialogSettings, PublishedGradleVersionsWrapper publishedGradleVersions) {
        super(PREF_SHOW_WELCOME_PAGE);
        this.setDialogSettings(dialogSettings);
        this.importController = new ProjectImportWizardController((IWizard)this);
        this.creationController = new ProjectCreationWizardController(this);
        this.pageChangeListener = new ProjectCreatingPageChangedListener(this);
        final ProjectImportConfiguration importConfiguration = this.importController.getConfiguration();
        ProjectCreationConfiguration creationConfiguration = this.creationController.getConfiguration();
        WelcomePageContent welcomePageContent = WelcomePageContentFactory.createCreationWizardWelcomePageContent();
        this.welcomeWizardPage = new GradleWelcomeWizardPage(importConfiguration, welcomePageContent);
        this.newGradleProjectPage = new NewGradleProjectWizardPage(importConfiguration, creationConfiguration);
        this.gradleOptionsPage = new GradleOptionsWizardPage(importConfiguration, publishedGradleVersions, ProjectWizardMessages.Title_NewGradleProjectOptionsWizardPage, ProjectWizardMessages.InfoMessage_NewGradleProjectOptionsWizardPageDefault, ProjectWizardMessages.InfoMessage_NewGradleProjectOptionsWizardPageContext);
        this.projectPreviewPage = new ProjectPreviewWizardPage(importConfiguration, new ProjectPreviewWizardPage.ProjectPreviewLoader(){

            @Override
            public Job loadPreview(FutureCallback<Pair<OmniBuildEnvironment, OmniGradleBuild>> resultHandler, List<ProgressListener> listeners) {
                ProjectPreviewJob projectPreviewJob = new ProjectPreviewJob(importConfiguration, listeners, (AsyncHandler)new NewGradleProjectInitializer(importConfiguration, listeners), resultHandler);
                projectPreviewJob.schedule();
                return projectPreviewJob;
            }
        }, ProjectWizardMessages.Title_NewGradleProjectPreviewWizardPage, ProjectWizardMessages.InfoMessage_NewGradleProjectPreviewWizardPageDefault, ProjectWizardMessages.InfoMessage_NewGradleProjectPreviewWizardPageContext);
    }

    public void setContainer(IWizardContainer wizardContainer) {
        if (wizardContainer instanceof IPageChangeProvider) {
            IPageChangeProvider pageChangeProvider = (IPageChangeProvider)wizardContainer;
            pageChangeProvider.addPageChangedListener(this.pageChangeListener);
        }
        super.setContainer(wizardContainer);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        List<String> workingSetNames = WorkingSetUtils.getSelectedWorkingSetNames(selection);
        if (!workingSetNames.isEmpty()) {
            this.importController.getConfiguration().setApplyWorkingSets(Boolean.valueOf(true));
            this.importController.getConfiguration().setWorkingSets(workingSetNames);
        }
    }

    public String getWindowTitle() {
        return ProjectWizardMessages.Title_NewGradleProjectWizardPage;
    }

    public void addPages() {
        if (this.isShowWelcomePage()) {
            this.addPage((IWizardPage)this.welcomeWizardPage);
        }
        this.addPage((IWizardPage)this.newGradleProjectPage);
        this.addPage((IWizardPage)this.gradleOptionsPage);
        this.addPage((IWizardPage)this.projectPreviewPage);
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public boolean performFinish() {
        return this.importController.performImportProject(new NewGradleProjectInitializer(this.importController.getConfiguration()), NewProjectHandler.IMPORT_AND_MERGE);
    }

    public boolean performCancel() {
        File projectDir;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (((Object)((Object)this.projectPreviewPage)).equals(currentPage) && (projectDir = (File)this.importController.getConfiguration().getProjectDir().getValue()) != null) {
            FileUtils.deleteRecursively((File)projectDir);
        }
        return true;
    }

    @Override
    public String getHelpContextId() {
        return "org.eclipse.buildship.ui.projectcreation";
    }

    public void dispose() {
        if (this.getContainer() instanceof IPageChangeProvider) {
            IPageChangeProvider pageChangeProvider = (IPageChangeProvider)this.getContainer();
            pageChangeProvider.removePageChangedListener(this.pageChangeListener);
        }
        super.dispose();
    }

    private static IDialogSettings getOrCreateDialogSection(IDialogSettings dialogSettings) {
        IDialogSettings section = dialogSettings.getSection(PROJECT_CREATION_DIALOG_SETTINGS);
        if (section == null) {
            section = dialogSettings.addNewSection(PROJECT_CREATION_DIALOG_SETTINGS);
        }
        return section;
    }

    private static final class NewGradleProjectInitializer
    implements AsyncHandler {
        private final FixedRequestAttributes fixedAttributes;
        private final Optional<List<ProgressListener>> listeners;

        private NewGradleProjectInitializer(ProjectImportConfiguration configuration) {
            this.fixedAttributes = configuration.toFixedAttributes();
            this.listeners = Optional.absent();
        }

        private NewGradleProjectInitializer(ProjectImportConfiguration configuration, List<ProgressListener> listeners) {
            this.fixedAttributes = configuration.toFixedAttributes();
            this.listeners = Optional.of((Object)ImmutableList.copyOf(listeners));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor, CancellationToken token) {
            monitor.beginTask("Init Gradle project", -1);
            try {
                File projectDir = this.fixedAttributes.getProjectDir().getAbsoluteFile();
                if (!projectDir.exists() && projectDir.mkdir()) {
                    ProgressListener[] progressListenerArray;
                    ImmutableList tasks = GRADLE_INIT_TASK_CMD_LINE;
                    if (this.listeners.isPresent()) {
                        progressListenerArray = ((List)this.listeners.get()).toArray(new ProgressListener[((List)this.listeners.get()).size()]);
                    } else {
                        ProgressListener[] progressListenerArray2 = new ProgressListener[1];
                        progressListenerArray = progressListenerArray2;
                        progressListenerArray2[0] = DelegatingProgressListener.withFullOutput((IProgressMonitor)monitor);
                    }
                    ProgressListener[] progressListeners = progressListenerArray;
                    BuildLaunchRequest request = CorePlugin.toolingClient().newBuildLaunchRequest(LaunchableConfig.forTasks((Iterable)tasks));
                    this.fixedAttributes.apply((BuildRequest)request);
                    request.projectDir(projectDir);
                    request.progressListeners(progressListeners);
                    request.cancellationToken(token);
                    request.executeAndWait();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private static final class ProjectCreatingPageChangedListener
    implements IPageChangedListener {
        private final ProjectCreationWizard projectCreationWizard;
        private IWizardPage previousPage;

        private ProjectCreatingPageChangedListener(ProjectCreationWizard projectCreationWizard) {
            this.projectCreationWizard = projectCreationWizard;
            this.previousPage = projectCreationWizard.newGradleProjectPage;
        }

        public void pageChanged(PageChangedEvent event) {
            File projectDir;
            if (((Object)((Object)this.projectCreationWizard.projectPreviewPage)).equals(this.previousPage) && ((Object)((Object)this.projectCreationWizard.gradleOptionsPage)).equals(event.getSelectedPage()) && (projectDir = (File)this.projectCreationWizard.importController.getConfiguration().getProjectDir().getValue()) != null) {
                FileUtils.deleteRecursively((File)projectDir);
                this.projectCreationWizard.newGradleProjectPage.setPageComplete(this.projectCreationWizard.newGradleProjectPage.isPageComplete());
            }
            this.previousPage = (IWizardPage)event.getSelectedPage();
        }
    }
}

