/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.configuration;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.buildship.core.GradleDistribution;

public final class BuildConfigurationProperties {
    private final File rootProjectDirectory;
    private final GradleDistribution gradleDistribution;
    private final File gradleUserHome;
    private final File javaHome;
    private final boolean overrideWorkspaceSettings;
    private final boolean buildScansEnabled;
    private final boolean offlineMode;
    private final boolean autoSync;
    private final List<String> arguments;
    private final List<String> jvmArguments;
    private final boolean showConsoleView;
    private final boolean showExecutionsView;

    public BuildConfigurationProperties(File rootProjectDirectory, GradleDistribution gradleDistribution, File gradleUserHome, File javaHome, boolean overrideWorkspaceSettings, boolean buildScansEnabled, boolean offlineMode, boolean autoSync, List<String> arguments, List<String> jvmArguments, boolean showConsoleView, boolean showExecutionsView) {
        this.rootProjectDirectory = BuildConfigurationProperties.canonicalize(rootProjectDirectory);
        this.gradleDistribution = gradleDistribution;
        this.gradleUserHome = gradleUserHome;
        this.javaHome = javaHome;
        this.overrideWorkspaceSettings = overrideWorkspaceSettings;
        this.buildScansEnabled = buildScansEnabled;
        this.offlineMode = offlineMode;
        this.autoSync = autoSync;
        this.arguments = arguments;
        this.jvmArguments = jvmArguments;
        this.showConsoleView = showConsoleView;
        this.showExecutionsView = showExecutionsView;
    }

    private static File canonicalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public File getRootProjectDirectory() {
        return this.rootProjectDirectory;
    }

    public GradleDistribution getGradleDistribution() {
        return this.gradleDistribution;
    }

    public File getGradleUserHome() {
        return this.gradleUserHome;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    public boolean isOverrideWorkspaceSettings() {
        return this.overrideWorkspaceSettings;
    }

    public boolean isBuildScansEnabled() {
        return this.buildScansEnabled;
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    public boolean isAutoSync() {
        return this.autoSync;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public boolean isShowConsoleView() {
        return this.showConsoleView;
    }

    public boolean isShowExecutionsView() {
        return this.showExecutionsView;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BuildConfigurationProperties) {
            BuildConfigurationProperties other = (BuildConfigurationProperties)obj;
            return Objects.equal((Object)this.rootProjectDirectory, (Object)other.rootProjectDirectory) && Objects.equal((Object)this.gradleDistribution, (Object)other.gradleDistribution) && Objects.equal((Object)this.gradleUserHome, (Object)other.gradleUserHome) && Objects.equal((Object)this.javaHome, (Object)other.javaHome) && Objects.equal((Object)this.overrideWorkspaceSettings, (Object)other.overrideWorkspaceSettings) && Objects.equal((Object)this.buildScansEnabled, (Object)other.buildScansEnabled) && Objects.equal((Object)this.offlineMode, (Object)other.offlineMode) && Objects.equal((Object)this.autoSync, (Object)other.autoSync) && Objects.equal(this.arguments, other.arguments) && Objects.equal(this.jvmArguments, other.jvmArguments) && Objects.equal((Object)this.showConsoleView, (Object)other.showConsoleView) && Objects.equal((Object)this.showExecutionsView, (Object)other.showExecutionsView);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rootProjectDirectory, this.gradleDistribution, this.gradleUserHome, this.javaHome, this.overrideWorkspaceSettings, this.buildScansEnabled, this.offlineMode, this.autoSync, this.arguments, this.jvmArguments, this.showConsoleView, this.showExecutionsView});
    }
}

