/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.stsmigration;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.buildship.stsmigration.StsMigrationPlugin;
import org.eclipse.buildship.stsmigration.StsMigrationState;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

class StsMigrationDialog
extends Dialog {
    private static final String STS_MIGRATION_DOCUMENT_URL = "https://github.com/eclipse/buildship/wiki/Migration-guide-from-STS-Gradle-to-Buildship";
    private static final String DIALOG_TITLE = "Migration from STS Gradle to Buildship";
    private static final String DIALOG_TEXT = "The development of the STS Gradle plugin has been discontinued.\n\nA document explaining the migration process from STS Gradle to Buildship can be found <a>here</a>.";
    private static final String MUTE_NOTIFICATION_TEXT = "Don't show this message again";
    private final StsMigrationState migrationState;

    private StsMigrationDialog(Shell shell, StsMigrationState migrationState) {
        super(shell);
        this.migrationState = migrationState;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(10, 10).extendedMargins(10, 10, 10, 10).applyTo(container);
        Label dialogIcon = new Label(container, 0);
        dialogIcon.setBackground(container.getBackground());
        dialogIcon.setImage(this.getShell().getDisplay().getSystemImage(2));
        dialogIcon.setLayoutData((Object)new GridData(16384, 128, false, false));
        Link migrationLink = new Link(container, 0);
        migrationLink.setText(DIALOG_TEXT);
        migrationLink.setLayoutData((Object)new GridData(0x1000000, 128, true, true));
        migrationLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.text.equals("here")) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(StsMigrationDialog.STS_MIGRATION_DOCUMENT_URL));
                    }
                    catch (PartInitException e) {
                        StsMigrationPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.buildship.stsmigration", "Failed to open external browser.", (Throwable)e));
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("Invalid Url: https://github.com/eclipse/buildship/wiki/Migration-guide-from-STS-Gradle-to-Buildship", e);
                    }
                }
            }
        });
        Button muteNotificationCheckbox = new Button(container, 32);
        muteNotificationCheckbox.setText(MUTE_NOTIFICATION_TEXT);
        muteNotificationCheckbox.setLayoutData((Object)new GridData(16384, 128, true, true, 2, 1));
        muteNotificationCheckbox.setSelection(this.migrationState.isNotificationMuted());
        muteNotificationCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StsMigrationDialog.this.migrationState.setNotificationMuted(((Button)e.getSource()).getSelection());
            }
        });
        return container;
    }

    static Factory factory() {
        return new Factory();
    }

    static class Factory {
        private Factory() {
        }

        StsMigrationDialog newInstance(Shell shell, StsMigrationState migrationState) {
            return new StsMigrationDialog(shell, migrationState);
        }
    }
}

