/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingmodel.OmniTaskSelector;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.TaskNode;

public final class TaskSelectorNode
implements TaskNode {
    private final ProjectNode parentProjectNode;
    private final OmniTaskSelector taskSelector;

    public TaskSelectorNode(ProjectNode parentProjectNode, OmniTaskSelector taskSelector) {
        this.parentProjectNode = (ProjectNode)Preconditions.checkNotNull((Object)parentProjectNode);
        this.taskSelector = (OmniTaskSelector)Preconditions.checkNotNull((Object)taskSelector);
    }

    @Override
    public ProjectNode getParentProjectNode() {
        return this.parentProjectNode;
    }

    public OmniTaskSelector getTaskSelector() {
        return this.taskSelector;
    }

    @Override
    public String getName() {
        return this.taskSelector.getName();
    }

    @Override
    public TaskNode.TaskNodeType getType() {
        return TaskNode.TaskNodeType.TASK_SELECTOR_NODE;
    }

    @Override
    public boolean isPublic() {
        return this.taskSelector.isPublic();
    }

    public String toString() {
        return this.taskSelector.getName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TaskSelectorNode that = (TaskSelectorNode)other;
        return Objects.equal((Object)this.parentProjectNode, (Object)that.parentProjectNode) && Objects.equal((Object)this.taskSelector, (Object)that.taskSelector);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parentProjectNode, this.taskSelector});
    }
}

