/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import java.util.Set;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.progress.ToolingApiJob;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.GradleBuilds;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.RunOnImportTasksOperation;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildOperation;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public final class SynchronizeGradleBuildsJob
extends ToolingApiJob {
    private final ImmutableSet<GradleBuild> builds;
    private final NewProjectHandler newProjectHandler;
    private final AsyncHandler initializer;

    private SynchronizeGradleBuildsJob(Set<GradleBuild> builds, NewProjectHandler newProjectHandler, AsyncHandler initializer) {
        super("Synchronize Gradle projects with workspace", true);
        this.builds = ImmutableSet.copyOf(builds);
        this.newProjectHandler = (NewProjectHandler)Preconditions.checkNotNull((Object)newProjectHandler);
        this.initializer = (AsyncHandler)Preconditions.checkNotNull((Object)initializer);
        this.setUser(true);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    @Override
    protected void runToolingApiJob(IProgressMonitor monitor) throws Exception {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.builds.size() + 1));
        this.initializer.run((IProgressMonitor)progress.newChild(1), this.getToken());
        for (GradleBuild build : this.builds) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.synchronizeBuild(build, progress.newChild(1));
        }
    }

    private void synchronizeBuild(GradleBuild build, SubMonitor progress) throws CoreException {
        progress.setTaskName(String.format("Synchronizing Gradle build at %s with workspace", build.getRequestAttributes().getProjectDir()));
        progress.setWorkRemaining(3);
        Set<OmniEclipseProject> allProjects = this.fetchEclipseProjects(build, progress.newChild(1));
        new RunOnImportTasksOperation(allProjects, build.getRequestAttributes()).run((IProgressMonitor)progress.newChild(1), this.getToken());
        new SynchronizeGradleBuildOperation(allProjects, build.getRequestAttributes(), this.newProjectHandler).run((IProgressMonitor)progress.newChild(1));
    }

    private Set<OmniEclipseProject> fetchEclipseProjects(GradleBuild build, SubMonitor progress) {
        progress.setTaskName("Loading Gradle project models");
        ModelProvider modelProvider = build.getModelProvider();
        return modelProvider.fetchEclipseGradleProjects(FetchStrategy.FORCE_RELOAD, this.getToken(), (IProgressMonitor)progress);
    }

    public boolean shouldSchedule() {
        for (Job job : Job.getJobManager().find((Object)"org.eclipse.buildship.core.jobs")) {
            if (!(job instanceof SynchronizeGradleBuildsJob) || !this.isCoveredBy((SynchronizeGradleBuildsJob)job)) continue;
            return false;
        }
        return true;
    }

    private boolean isCoveredBy(SynchronizeGradleBuildsJob other) {
        return !(!Objects.equal(this.builds, other.builds) || this.newProjectHandler != NewProjectHandler.NO_OP && !Objects.equal((Object)this.newProjectHandler, (Object)other.newProjectHandler) || this.initializer != AsyncHandler.NO_OP && !Objects.equal((Object)this.initializer, (Object)other.initializer));
    }

    public static SynchronizeGradleBuildsJob forSingleGradleBuild(GradleBuild build, NewProjectHandler newProjectHandler, AsyncHandler initializer) {
        return new SynchronizeGradleBuildsJob((Set<GradleBuild>)ImmutableSet.of((Object)build), newProjectHandler, initializer);
    }

    public static SynchronizeGradleBuildsJob forMultipleGradleBuilds(GradleBuilds builds, NewProjectHandler newProjectHandler, AsyncHandler initializer) {
        return new SynchronizeGradleBuildsJob(builds.getGradleBuilds(), newProjectHandler, initializer);
    }
}

