/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class OperationDescriptorRenderer {
    private OperationDescriptorRenderer() {
    }

    public static String renderVerbose(FinishEvent finishEvent) {
        OperationDescriptor descriptor = finishEvent.getDescriptor();
        return OperationDescriptorRenderer.render(descriptor, finishEvent, true);
    }

    public static String renderCompact(OperationItem operationItem) {
        OperationDescriptor descriptor = operationItem.getStartEvent().getDescriptor();
        FinishEvent finishEvent = operationItem.getFinishEvent();
        return OperationDescriptorRenderer.render(descriptor, finishEvent, false);
    }

    private static String render(OperationDescriptor descriptor, FinishEvent finishEvent, boolean verbose) {
        if (descriptor instanceof TaskOperationDescriptor) {
            return OperationDescriptorRenderer.renderTask(finishEvent, (TaskOperationDescriptor)descriptor, verbose);
        }
        if (descriptor instanceof TestOperationDescriptor) {
            return OperationDescriptorRenderer.renderTest(descriptor, verbose);
        }
        return OperationDescriptorRenderer.renderOther(descriptor);
    }

    private static String renderTask(FinishEvent finishEvent, TaskOperationDescriptor descriptor, boolean verbose) {
        StringBuilder task = new StringBuilder();
        if (verbose) {
            task.append("Task ");
        }
        task.append(descriptor.getTaskPath());
        if (finishEvent instanceof TaskFinishEvent && finishEvent.getResult() instanceof TaskSuccessResult) {
            TaskSuccessResult taskResult = (TaskSuccessResult)finishEvent.getResult();
            if (taskResult.isFromCache()) {
                task.append(" FROM-CACHE");
            } else if (taskResult.isUpToDate()) {
                task.append(" UP-TO-DATE");
            }
        }
        return task.toString();
    }

    private static String renderTest(OperationDescriptor descriptor, boolean verbose) {
        if (verbose) {
            return String.format("Test '%s'", descriptor.getName());
        }
        return descriptor.getName();
    }

    private static String renderOther(OperationDescriptor descriptor) {
        return descriptor.getDisplayName();
    }
}

