/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.view.execution.ExecutionPage;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;

public final class CancelBuildExecutionAction
extends Action {
    private final ExecutionPage page;

    public CancelBuildExecutionAction(ExecutionPage page) {
        this.page = (ExecutionPage)Preconditions.checkNotNull((Object)page);
        this.setToolTipText(UiMessages.Action_CancelExecution_Tooltip);
        this.setImageDescriptor(PluginImages.CANCEL_BUILD_EXECUTION.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.CANCEL_BUILD_EXECUTION.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.registerJobChangeListener();
    }

    private void registerJobChangeListener() {
        Job job = this.page.getProcessDescription().getJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                CancelBuildExecutionAction.this.setEnabled(event.getJob().getState() != 0);
            }
        });
        this.setEnabled(job.getState() != 0);
    }

    public void run() {
        this.page.getProcessDescription().getJob().cancel();
    }
}

