/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.launch.GradleLaunchConfigurationManager;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.util.collections.CollectionsUtils;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public final class DefaultGradleLaunchConfigurationManager
implements GradleLaunchConfigurationManager {
    private final ILaunchManager launchManager;

    public DefaultGradleLaunchConfigurationManager() {
        this(DebugPlugin.getDefault().getLaunchManager());
    }

    public DefaultGradleLaunchConfigurationManager(ILaunchManager launchManager) {
        this.launchManager = (ILaunchManager)Preconditions.checkNotNull((Object)launchManager);
    }

    @Override
    public Optional<ILaunchConfiguration> getRunConfiguration(GradleRunConfigurationAttributes configurationAttributes) {
        Preconditions.checkNotNull((Object)configurationAttributes);
        for (ILaunchConfiguration launchConfiguration : this.getGradleLaunchConfigurations()) {
            if (!configurationAttributes.hasSameUniqueAttributes(launchConfiguration)) continue;
            return Optional.of((Object)launchConfiguration);
        }
        return Optional.absent();
    }

    @Override
    public ILaunchConfiguration getOrCreateRunConfiguration(GradleRunConfigurationAttributes configurationAttributes) {
        Preconditions.checkNotNull((Object)configurationAttributes);
        Optional<ILaunchConfiguration> launchConfiguration = this.getRunConfiguration(configurationAttributes);
        return launchConfiguration.isPresent() ? (ILaunchConfiguration)launchConfiguration.get() : this.createLaunchConfiguration(configurationAttributes);
    }

    private ILaunchConfiguration createLaunchConfiguration(GradleRunConfigurationAttributes configurationAttributes) {
        String taskNamesOrDefault = configurationAttributes.getTasks().isEmpty() ? "(default tasks)" : CollectionsUtils.joinWithSpace(configurationAttributes.getTasks());
        String rawLaunchConfigurationName = String.format("%s - %s", configurationAttributes.getWorkingDir().getName(), taskNamesOrDefault);
        String launchConfigurationName = this.launchManager.generateLaunchConfigurationName(rawLaunchConfigurationName.replace(':', '.'));
        ILaunchConfigurationType launchConfigurationType = this.launchManager.getLaunchConfigurationType("org.eclipse.buildship.core.launch.runconfiguration");
        try {
            ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance(null, launchConfigurationName);
            configurationAttributes.apply(launchConfiguration);
            return launchConfiguration.doSave();
        }
        catch (Exception e) {
            String message = String.format("Cannot create Gradle launch configuration %s.", launchConfigurationName);
            CorePlugin.logger().error(message, e);
            throw new GradlePluginsRuntimeException(e);
        }
    }

    private ILaunchConfiguration[] getGradleLaunchConfigurations() {
        ILaunchConfigurationType launchConfigurationType = this.launchManager.getLaunchConfigurationType("org.eclipse.buildship.core.launch.runconfiguration");
        try {
            return this.launchManager.getLaunchConfigurations(launchConfigurationType);
        }
        catch (Exception e) {
            String message = "Cannot get Gradle launch configurations.";
            CorePlugin.logger().error(message, e);
            throw new GradlePluginsRuntimeException(message, e);
        }
    }
}

