/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniEclipseSourceDirectory;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class SourceFolderUpdater {
    private static final String CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL = "FROM_GRADLE_MODEL";
    private final IJavaProject project;
    private final List<OmniEclipseSourceDirectory> sourceFolders;

    private SourceFolderUpdater(IJavaProject project, List<OmniEclipseSourceDirectory> sourceFolders) {
        this.project = (IJavaProject)Preconditions.checkNotNull((Object)project);
        this.sourceFolders = (List)Preconditions.checkNotNull(sourceFolders);
    }

    private void updateClasspath(IProgressMonitor monitor) throws JavaModelException {
        List<IClasspathEntry> gradleSourceFolders = this.collectGradleSourceFolders();
        List<IClasspathEntry> newClasspathEntries = this.calculateNewClasspath(gradleSourceFolders);
        this.updateClasspath(newClasspathEntries, monitor);
    }

    private List<IClasspathEntry> collectGradleSourceFolders() {
        ImmutableList sourceFolders = FluentIterable.from(this.sourceFolders).transform((Function)new Function<OmniEclipseSourceDirectory, IClasspathEntry>(){

            public IClasspathEntry apply(OmniEclipseSourceDirectory directory) {
                IFolder sourceDirectory = SourceFolderUpdater.this.project.getProject().getFolder(Path.fromOSString((String)directory.getPath()));
                FileUtils.ensureFolderHierarchyExists(sourceDirectory);
                IPackageFragmentRoot root = SourceFolderUpdater.this.project.getPackageFragmentRoot((IResource)sourceDirectory);
                IClasspathAttribute fromGradleModel = JavaCore.newClasspathAttribute((String)SourceFolderUpdater.CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL, (String)"true");
                return JavaCore.newSourceEntry((IPath)root.getPath(), (IPath[])new IPath[0], (IPath[])new IPath[0], null, (IClasspathAttribute[])new IClasspathAttribute[]{fromGradleModel});
            }
        }).toList();
        return ImmutableSet.copyOf((Collection)sourceFolders).asList();
    }

    private List<IClasspathEntry> calculateNewClasspath(List<IClasspathEntry> gradleSourceFolders) throws JavaModelException {
        ImmutableSet gradleModelSourcePaths = FluentIterable.from(gradleSourceFolders).transform((Function)new Function<IClasspathEntry, String>(){

            public String apply(IClasspathEntry entry) {
                return entry.getPath().toString();
            }
        }).toSet();
        ImmutableList rawClasspath = ImmutableList.copyOf((Object[])this.project.getRawClasspath());
        ImmutableList manuallyAddedSourceFolders = FluentIterable.from((Iterable)rawClasspath).filter((Predicate)new Predicate<IClasspathEntry>((Set)gradleModelSourcePaths){
            final /* synthetic */ Set val$gradleModelSourcePaths;
            {
                this.val$gradleModelSourcePaths = set;
            }

            public boolean apply(IClasspathEntry entry) {
                if (this.val$gradleModelSourcePaths.contains(entry.getPath().toString())) {
                    return false;
                }
                for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
                    if (!attribute.getName().equals(SourceFolderUpdater.CLASSPATH_ATTRIBUTE_FROM_GRADLE_MODEL) || !attribute.getValue().equals("true")) continue;
                    return false;
                }
                return true;
            }
        }).toList();
        return ImmutableList.builder().addAll(gradleSourceFolders).addAll((Iterable)manuallyAddedSourceFolders).build();
    }

    private void updateClasspath(List<IClasspathEntry> newClasspathEntries, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] newRawClasspath = newClasspathEntries.toArray(new IClasspathEntry[newClasspathEntries.size()]);
        this.project.setRawClasspath(newRawClasspath, monitor);
    }

    public static void update(IJavaProject project, List<OmniEclipseSourceDirectory> sourceFolders, IProgressMonitor monitor) throws JavaModelException {
        SourceFolderUpdater updater = new SourceFolderUpdater(project, sourceFolders);
        updater.updateClasspath(monitor);
    }
}

