/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.gradleware.tooling.toolingmodel.Path;
import java.io.File;
import java.util.HashMap;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.configuration.ProjectConfigurationManager;
import org.eclipse.buildship.core.configuration.internal.ProjectConfigurationPersistence;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.core.resources.IProject;

public final class DefaultProjectConfigurationManager
implements ProjectConfigurationManager {
    private final WorkspaceOperations workspaceOperations;
    private final ProjectConfigurationPersistence projectConfigurationPersistence;

    public DefaultProjectConfigurationManager(WorkspaceOperations workspaceOperations) {
        this.workspaceOperations = workspaceOperations;
        this.projectConfigurationPersistence = new ProjectConfigurationPersistence();
    }

    @Override
    public ImmutableSet<ProjectConfiguration> getRootProjectConfigurations() {
        ImmutableSet.Builder rootConfigurations = ImmutableSet.builder();
        for (IProject workspaceProject : this.workspaceOperations.getAllProjects()) {
            if (!workspaceProject.isOpen() || !GradleProjectNature.INSTANCE.isPresentOn(workspaceProject)) continue;
            ProjectConfiguration projectConfiguration = this.projectConfigurationPersistence.readProjectConfiguration(workspaceProject);
            File rootProjectDir = projectConfiguration.getRequestAttributes().getProjectDir();
            ProjectConfiguration rootProjectConfiguration = ProjectConfiguration.from(projectConfiguration.getRequestAttributes(), Path.from((String)":"), rootProjectDir);
            rootConfigurations.add((Object)rootProjectConfiguration);
        }
        HashMap rootProjectDirs = Maps.newHashMap();
        for (ProjectConfiguration rootProjectConfiguration : rootConfigurations.build()) {
            String rootProjectDirPath = rootProjectConfiguration.getProjectDir().getPath();
            if (!rootProjectDirs.containsKey(rootProjectDirPath)) {
                rootProjectDirs.put(rootProjectDirPath, rootProjectConfiguration);
                continue;
            }
            String message = String.format("Inconsistent Gradle project configuration for project at %s.", rootProjectDirPath);
            CorePlugin.logger().error(message);
            throw new GradlePluginsRuntimeException(message);
        }
        return rootConfigurations.build();
    }

    @Override
    public ImmutableSet<ProjectConfiguration> getAllProjectConfigurations() {
        ImmutableSet.Builder allConfigurations = ImmutableSet.builder();
        for (IProject workspaceProject : this.workspaceOperations.getAllProjects()) {
            if (!workspaceProject.isOpen() || !GradleProjectNature.INSTANCE.isPresentOn(workspaceProject)) continue;
            ProjectConfiguration projectConfiguration = this.projectConfigurationPersistence.readProjectConfiguration(workspaceProject);
            allConfigurations.add((Object)projectConfiguration);
        }
        return allConfigurations.build();
    }

    @Override
    public void saveProjectConfiguration(ProjectConfiguration projectConfiguration, IProject workspaceProject) {
        this.projectConfigurationPersistence.saveProjectConfiguration(projectConfiguration, workspaceProject);
    }

    @Override
    public ProjectConfiguration readProjectConfiguration(IProject workspaceProject) {
        return this.projectConfigurationPersistence.readProjectConfiguration(workspaceProject);
    }
}

