/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingclient.SimpleRequest;
import com.gradleware.tooling.toolingclient.TestConfig;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.launch.BaseLaunchRequestJob;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class RunGradleTestLaunchRequestJob
extends BaseLaunchRequestJob {
    private final ImmutableList<TestOperationDescriptor> testDescriptors;
    private final GradleRunConfigurationAttributes configurationAttributes;

    public RunGradleTestLaunchRequestJob(List<TestOperationDescriptor> testDescriptors, GradleRunConfigurationAttributes configurationAttributes) {
        super("Launching Gradle tests", false);
        this.testDescriptors = ImmutableList.copyOf(testDescriptors);
        this.configurationAttributes = (GradleRunConfigurationAttributes)Preconditions.checkNotNull((Object)configurationAttributes);
    }

    @Override
    protected String getJobTaskName() {
        return "Launch Gradle tests";
    }

    @Override
    protected GradleRunConfigurationAttributes getConfigurationAttributes() {
        return this.configurationAttributes;
    }

    @Override
    protected ProcessDescription createProcessDescription() {
        String processName = this.createProcessName(this.configurationAttributes.getWorkingDir());
        return new TestLaunchProcessDescription(processName);
    }

    private String createProcessName(File workingDir) {
        return String.format("%s [Gradle Project] %s in %s (%s)", this.collectTestTaskNames((List<TestOperationDescriptor>)this.testDescriptors), Joiner.on((char)' ').join(RunGradleTestLaunchRequestJob.collectSimpleDisplayNames(this.testDescriptors)), workingDir.getAbsolutePath(), DateFormat.getDateTimeInstance(2, 2).format(new Date()));
    }

    private String collectTestTaskNames(List<TestOperationDescriptor> testDescriptors) {
        ImmutableList.Builder testTaskNames = ImmutableList.builder();
        for (TestOperationDescriptor testDescriptor : testDescriptors) {
            Optional<TaskOperationDescriptor> taskDescriptor = this.findParentTestTask((OperationDescriptor)testDescriptor);
            testTaskNames.add((Object)(taskDescriptor.isPresent() ? ((TaskOperationDescriptor)taskDescriptor.get()).getTaskPath() : "Test"));
        }
        return Joiner.on((char)' ').join((Iterable)ImmutableSet.copyOf((Collection)testTaskNames.build()));
    }

    private Optional<TaskOperationDescriptor> findParentTestTask(OperationDescriptor testDescriptor) {
        OperationDescriptor parent = testDescriptor.getParent();
        if (parent instanceof TaskOperationDescriptor) {
            return Optional.of((Object)((TaskOperationDescriptor)parent));
        }
        if (parent != null) {
            return this.findParentTestTask(parent);
        }
        return Optional.absent();
    }

    @Override
    protected SimpleRequest<Void> createRequest() {
        return CorePlugin.toolingClient().newTestLaunchRequest(TestConfig.forTests(this.testDescriptors));
    }

    @Override
    protected void writeExtraConfigInfo(OutputStreamWriter writer) throws IOException {
        writer.write(String.format("%s: %s%n", CoreMessages.RunConfiguration_Label_Tests, Joiner.on((char)' ').join(RunGradleTestLaunchRequestJob.collectQualifiedDisplayNames(this.testDescriptors))));
    }

    private static List<String> collectQualifiedDisplayNames(List<TestOperationDescriptor> testDescriptors) {
        return FluentIterable.from(testDescriptors).transform((Function)new Function<TestOperationDescriptor, String>(){

            public String apply(TestOperationDescriptor descriptor) {
                if (descriptor instanceof JvmTestOperationDescriptor) {
                    JvmTestOperationDescriptor jvmTestDescriptor = (JvmTestOperationDescriptor)descriptor;
                    String className = jvmTestDescriptor.getClassName();
                    String methodName = jvmTestDescriptor.getMethodName();
                    return methodName != null ? className + "#" + methodName : className;
                }
                return descriptor.getDisplayName();
            }
        }).toList();
    }

    private static List<String> collectSimpleDisplayNames(List<TestOperationDescriptor> testDescriptors) {
        return FluentIterable.from(testDescriptors).transform((Function)new Function<TestOperationDescriptor, String>(){

            public String apply(TestOperationDescriptor descriptor) {
                if (descriptor instanceof JvmTestOperationDescriptor) {
                    JvmTestOperationDescriptor jvmTestDescriptor = (JvmTestOperationDescriptor)descriptor;
                    String className = jvmTestDescriptor.getClassName();
                    String methodName = jvmTestDescriptor.getMethodName();
                    int index = className.lastIndexOf(46);
                    if (index >= 0 && className.length() > index + 1) {
                        className = className.substring(index + 1);
                    }
                    return methodName != null ? className + "#" + methodName : className;
                }
                return descriptor.getDisplayName();
            }
        }).toList();
    }

    private final class TestLaunchProcessDescription
    extends BaseLaunchRequestJob.BaseProcessDescription {
        public TestLaunchProcessDescription(String processName) {
            super(processName, RunGradleTestLaunchRequestJob.this, RunGradleTestLaunchRequestJob.this.configurationAttributes);
        }

        @Override
        public boolean isRerunnable() {
            return true;
        }

        @Override
        public void rerun() {
            RunGradleTestLaunchRequestJob job = new RunGradleTestLaunchRequestJob((List<TestOperationDescriptor>)RunGradleTestLaunchRequestJob.this.testDescriptors, RunGradleTestLaunchRequestJob.this.configurationAttributes);
            job.schedule();
        }
    }
}

