/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImageWithState;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskGroupNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class TaskNameLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final ILabelProvider workbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();

    public String getText(Object element) {
        return element == null ? "" : this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof ProjectTaskNode) {
            return this.getProjectTaskText((ProjectTaskNode)element);
        }
        if (element instanceof TaskSelectorNode) {
            return this.getTaskSelectorText((TaskSelectorNode)element);
        }
        if (element instanceof ProjectNode) {
            return this.getProjectText((ProjectNode)element);
        }
        if (element instanceof TaskGroupNode) {
            return this.getGroupText((TaskGroupNode)element);
        }
        throw new IllegalStateException(String.format("Unknown element type of element %s.", element));
    }

    public Image getImage(Object element) {
        if (element instanceof ProjectTaskNode) {
            return this.getProjectTaskImage((ProjectTaskNode)element);
        }
        if (element instanceof TaskSelectorNode) {
            return this.getTaskSelectorImage((TaskSelectorNode)element);
        }
        if (element instanceof ProjectNode) {
            return this.getProjectImage((ProjectNode)element);
        }
        if (element instanceof TaskGroupNode) {
            return this.getGroupImage((TaskGroupNode)element);
        }
        throw new IllegalStateException(String.format("Unknown element type of element %s.", element));
    }

    private StyledString getTaskSelectorText(TaskSelectorNode taskSelector) {
        return new StyledString(taskSelector.getTaskSelector().getName());
    }

    private StyledString getProjectTaskText(ProjectTaskNode projectTask) {
        return new StyledString(projectTask.getProjectTask().getName());
    }

    private StyledString getGroupText(TaskGroupNode group) {
        String displayName = group.getName().toLowerCase();
        return new StyledString(displayName);
    }

    private StyledString getProjectText(ProjectNode project) {
        Optional<IProject> workspaceProject = project.getWorkspaceProject();
        String name = workspaceProject.isPresent() ? ((IProject)workspaceProject.get()).getName() : project.getEclipseProject().getName();
        return new StyledString(name);
    }

    private Image getProjectImage(ProjectNode project) {
        Optional<IProject> workspaceProject = project.getWorkspaceProject();
        if (workspaceProject.isPresent()) {
            return this.workbenchLabelProvider.getImage(workspaceProject.get());
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
    }

    private Image getGroupImage(TaskGroupNode element) {
        return PluginImages.TASK_GROUP.withState(PluginImage.ImageState.ENABLED).getImage();
    }

    private Image getProjectTaskImage(ProjectTaskNode projectTask) {
        return this.getOverlayImageForProjectTask(projectTask);
    }

    private Image getTaskSelectorImage(TaskSelectorNode taskSelector) {
        return this.getOverlayImageForTaskSelector(taskSelector);
    }

    private Image getOverlayImageForProjectTask(ProjectTaskNode projectTask) {
        ImmutableList.Builder overlayImages = ImmutableList.builder();
        overlayImages.add((Object)PluginImages.OVERLAY_PROJECT_TASK.withState(PluginImage.ImageState.ENABLED));
        if (!projectTask.isPublic()) {
            overlayImages.add((Object)PluginImages.OVERLAY_PRIVATE_TASK.withState(PluginImage.ImageState.ENABLED));
        }
        return this.getOverlayImage((List<PluginImageWithState>)overlayImages.build());
    }

    private Image getOverlayImageForTaskSelector(TaskSelectorNode taskSelector) {
        ImmutableList.Builder overlayImages = ImmutableList.builder();
        overlayImages.add((Object)PluginImages.OVERLAY_TASK_SELECTOR.withState(PluginImage.ImageState.ENABLED));
        if (!taskSelector.isPublic()) {
            overlayImages.add((Object)PluginImages.OVERLAY_PRIVATE_TASK.withState(PluginImage.ImageState.ENABLED));
        }
        return this.getOverlayImage((List<PluginImageWithState>)overlayImages.build());
    }

    private Image getOverlayImage(List<PluginImageWithState> overlayImages) {
        return PluginImages.TASK.withState(PluginImage.ImageState.ENABLED).getOverlayImage(overlayImages);
    }

    public void dispose() {
        this.workbenchLabelProvider.dispose();
        super.dispose();
    }
}

