/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.gradleware.tooling.toolingmodel.OmniBuildInvocations;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import com.gradleware.tooling.toolingmodel.OmniTaskSelector;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildInvocations;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildInvocationsContainer;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniProjectTask;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniTaskSelector;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.Task;

public final class DefaultOmniBuildInvocationsContainerBuilder {
    private static final String NULL_STRING = new String();

    public static DefaultOmniBuildInvocationsContainer build(GradleProject project, boolean enforceAllTasksPublic) {
        ImmutableMultimap<Path, OmniProjectTask> tasks = DefaultOmniBuildInvocationsContainerBuilder.buildProjectTasksRecursively(project, (Multimap<Path, OmniProjectTask>)ArrayListMultimap.create(), enforceAllTasksPublic);
        ImmutableMultimap<Path, OmniTaskSelector> taskSelectors = DefaultOmniBuildInvocationsContainerBuilder.buildTaskSelectorsRecursively(project, (Multimap<Path, OmniTaskSelector>)ArrayListMultimap.create(), enforceAllTasksPublic);
        ImmutableSortedMap<Path, OmniBuildInvocations> buildInvocationsPerProject = DefaultOmniBuildInvocationsContainerBuilder.buildBuildInvocationsMapping(project, tasks, taskSelectors);
        return DefaultOmniBuildInvocationsContainer.from(buildInvocationsPerProject);
    }

    private static ImmutableSortedMap<Path, OmniBuildInvocations> buildBuildInvocationsMapping(GradleProject project, Multimap<Path, OmniProjectTask> projectTasks, Multimap<Path, OmniTaskSelector> taskSelectors) {
        Preconditions.checkState((boolean)taskSelectors.keySet().containsAll(projectTasks.keySet()), (Object)"Task selectors are always configured for all projects");
        ImmutableSortedMap.Builder mapping = ImmutableSortedMap.orderedBy((Comparator)Path.Comparator.INSTANCE);
        for (Path projectPath : taskSelectors.keySet()) {
            ImmutableList projectTasksOfProject = ImmutableSortedSet.orderedBy((Comparator)TaskComparator.INSTANCE).addAll((Iterable)projectTasks.get((Object)projectPath)).build().asList();
            ImmutableList taskSelectorsOfProject = ImmutableSortedSet.orderedBy((Comparator)TaskSelectorComparator.INSTANCE).addAll((Iterable)taskSelectors.get((Object)projectPath)).build().asList();
            mapping.put((Object)projectPath, (Object)DefaultOmniBuildInvocations.from((List<OmniProjectTask>)projectTasksOfProject, (List<OmniTaskSelector>)taskSelectorsOfProject));
        }
        LinkedHashSet projectPaths = Sets.newLinkedHashSet();
        DefaultOmniBuildInvocationsContainerBuilder.collectProjectPathsRecursively(project, projectPaths);
        projectPaths.removeAll(taskSelectors.keySet());
        for (Path projectPath : projectPaths) {
            mapping.put((Object)projectPath, (Object)DefaultOmniBuildInvocations.from((List<OmniProjectTask>)ImmutableList.of(), (List<OmniTaskSelector>)ImmutableList.of()));
        }
        return mapping.build();
    }

    private static void collectProjectPathsRecursively(GradleProject project, Set<Path> projectPaths) {
        projectPaths.add(Path.from(project.getPath()));
        for (GradleProject childProject : project.getChildren()) {
            DefaultOmniBuildInvocationsContainerBuilder.collectProjectPathsRecursively(childProject, projectPaths);
        }
    }

    private static ImmutableMultimap<Path, OmniProjectTask> buildProjectTasksRecursively(GradleProject project, Multimap<Path, OmniProjectTask> tasksPerProject, boolean enforceAllTasksPublic) {
        for (GradleTask task : project.getTasks()) {
            tasksPerProject.put((Object)Path.from(project.getPath()), (Object)DefaultOmniProjectTask.from((Task)task, enforceAllTasksPublic));
        }
        for (GradleProject childProject : project.getChildren()) {
            DefaultOmniBuildInvocationsContainerBuilder.buildProjectTasksRecursively(childProject, tasksPerProject, enforceAllTasksPublic);
        }
        return ImmutableMultimap.copyOf(tasksPerProject);
    }

    private static ImmutableMultimap<Path, OmniTaskSelector> buildTaskSelectorsRecursively(GradleProject project, Multimap<Path, OmniTaskSelector> taskSelectorsPerProject, boolean enforceAllTasksPublic) {
        TreeBasedTable aggregatedTasksWithDescription = TreeBasedTable.create((Comparator)Ordering.usingToString(), (Comparator)Path.Comparator.INSTANCE);
        LinkedHashSet publicTasks = Sets.newLinkedHashSet();
        DefaultOmniBuildInvocationsContainerBuilder.collectAllTasksRecursively(project, (Table<String, Path, String>)aggregatedTasksWithDescription, publicTasks, enforceAllTasksPublic);
        for (String selectorName : aggregatedTasksWithDescription.rowKeySet()) {
            SortedMap pathsAndDescriptions = aggregatedTasksWithDescription.row((Object)selectorName);
            String description = (String)pathsAndDescriptions.get(pathsAndDescriptions.firstKey());
            ImmutableSortedSet fqnTaskNames = ImmutableSortedSet.orderedBy((Comparator)Path.Comparator.INSTANCE).addAll(pathsAndDescriptions.keySet()).build();
            DefaultOmniTaskSelector taskSelector = DefaultOmniTaskSelector.from(selectorName, description != NULL_STRING ? description : null, Path.from(project.getPath()), publicTasks.contains(selectorName), (SortedSet<Path>)fqnTaskNames);
            taskSelectorsPerProject.put((Object)Path.from(project.getPath()), (Object)taskSelector);
        }
        DomainObjectSet childProjects = project.getChildren();
        for (GradleProject childProject : childProjects) {
            DefaultOmniBuildInvocationsContainerBuilder.buildTaskSelectorsRecursively(childProject, taskSelectorsPerProject, enforceAllTasksPublic);
        }
        return ImmutableMultimap.copyOf(taskSelectorsPerProject);
    }

    private static void collectAllTasksRecursively(GradleProject project, Table<String, Path, String> tasksWithDescription, Collection<String> publicTasks, boolean enforceAllTasksPublic) {
        for (GradleTask task : project.getTasks()) {
            DefaultOmniProjectTask projectTask = DefaultOmniProjectTask.from((Task)task, enforceAllTasksPublic);
            tasksWithDescription.put((Object)projectTask.getName(), (Object)projectTask.getPath(), (Object)(projectTask.getDescription() != null ? projectTask.getDescription() : NULL_STRING));
            if (!projectTask.isPublic()) continue;
            publicTasks.add(task.getName());
        }
        for (GradleProject childProject : project.getChildren()) {
            DefaultOmniBuildInvocationsContainerBuilder.collectAllTasksRecursively(childProject, tasksWithDescription, publicTasks, enforceAllTasksPublic);
        }
    }

    private static enum TaskComparator implements Comparator<OmniProjectTask>
    {
        INSTANCE;


        @Override
        public int compare(OmniProjectTask o1, OmniProjectTask o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static enum TaskSelectorComparator implements Comparator<OmniTaskSelector>
    {
        INSTANCE;


        @Override
        public int compare(OmniTaskSelector o1, OmniTaskSelector o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

