/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.BuildRequest;
import com.gradleware.tooling.toolingclient.TestConfig;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.launch.BaseLaunchRequestJob;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.launch.TestTarget;

public final class RunGradleJvmTestLaunchRequestJob
extends BaseLaunchRequestJob {
    private final ImmutableList<TestTarget> testTargets;
    private final GradleRunConfigurationAttributes configurationAttributes;

    public RunGradleJvmTestLaunchRequestJob(List<TestTarget> testTargets, GradleRunConfigurationAttributes configurationAttributes) {
        super("Launching Gradle Tests", false);
        this.testTargets = ImmutableList.copyOf(testTargets);
        this.configurationAttributes = (GradleRunConfigurationAttributes)Preconditions.checkNotNull((Object)configurationAttributes);
    }

    @Override
    protected String getJobTaskName() {
        return "Launch Gradle test classes";
    }

    @Override
    protected GradleRunConfigurationAttributes getConfigurationAttributes() {
        return this.configurationAttributes;
    }

    @Override
    protected ProcessDescription createProcessDescription() {
        String processName = this.createProcessName(this.configurationAttributes.getWorkingDir());
        return new TestLaunchProcessDescription(processName);
    }

    private String createProcessName(File workingDir) {
        return String.format("[Gradle Project] %s in %s (%s)", Joiner.on((char)' ').join(RunGradleJvmTestLaunchRequestJob.collectSimpleNames(this.testTargets)), workingDir.getAbsolutePath(), DateFormat.getDateTimeInstance(2, 2).format(new Date()));
    }

    @Override
    protected BuildRequest<Void> createRequest() {
        TestConfig.Builder testConfig = new TestConfig.Builder();
        for (TestTarget testTarget : this.testTargets) {
            testTarget.apply(testConfig);
        }
        return CorePlugin.toolingClient().newTestLaunchRequest(testConfig.build());
    }

    @Override
    protected void writeExtraConfigInfo(OutputStreamWriter writer) throws IOException {
        writer.write(String.format("%s: %s%n", CoreMessages.RunConfiguration_Label_Tests, Joiner.on((char)' ').join(RunGradleJvmTestLaunchRequestJob.collectQualifiedNames(this.testTargets))));
    }

    private static Collection<String> collectQualifiedNames(ImmutableList<TestTarget> testTargets) {
        return FluentIterable.from(testTargets).transform((Function)new Function<TestTarget, String>(){

            public String apply(TestTarget testTarget) {
                return testTarget.getQualifiedName();
            }
        }).toSet();
    }

    private static Collection<String> collectSimpleNames(ImmutableList<TestTarget> testTargets) {
        return FluentIterable.from(testTargets).transform((Function)new Function<TestTarget, String>(){

            public String apply(TestTarget testTarget) {
                return testTarget.getSimpleName();
            }
        }).toSet();
    }

    private final class TestLaunchProcessDescription
    extends BaseLaunchRequestJob.BaseProcessDescription {
        public TestLaunchProcessDescription(String processName) {
            super(processName, RunGradleJvmTestLaunchRequestJob.this, RunGradleJvmTestLaunchRequestJob.this.configurationAttributes);
        }

        @Override
        public boolean isRerunnable() {
            return true;
        }

        @Override
        public void rerun() {
            RunGradleJvmTestLaunchRequestJob job = new RunGradleJvmTestLaunchRequestJob((List<TestTarget>)RunGradleJvmTestLaunchRequestJob.this.testTargets, RunGradleJvmTestLaunchRequestJob.this.configurationAttributes);
            job.schedule();
        }
    }
}

