/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.nodeselection;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;

public final class SelectionHistoryManager {
    private final TreeViewer treeViewer;
    private final TreeViewerSelectionListener listener;
    private NodeSelection selectionHistory;

    public SelectionHistoryManager(TreeViewer treeViewer) {
        this.treeViewer = (TreeViewer)Preconditions.checkNotNull((Object)treeViewer);
        this.listener = new TreeViewerSelectionListener();
        this.selectionHistory = NodeSelection.empty();
        this.init();
    }

    private void init() {
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.listener);
    }

    public NodeSelection getSelectionHistory() {
        return this.selectionHistory;
    }

    private void handleSelection(IStructuredSelection selection) {
        NodeSelection nodeSelection = NodeSelection.from(selection);
        this.selectionHistory = this.selectionHistory.mergeWith(nodeSelection);
    }

    public void dispose() {
        this.treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.listener);
    }

    private final class TreeViewerSelectionListener
    implements ISelectionChangedListener {
        private TreeViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                SelectionHistoryManager.this.handleSelection((IStructuredSelection)selection);
            }
        }
    }
}

