/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseBuildCommand;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.workspace.internal.StringSetProjectProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

final class BuildCommandUpdater {
    private static final String PROJECT_PROPERTY_KEY_GRADLE_BUILD_COMMANDS = "build.commands";
    private final IProject project;
    private final ImmutableList<OmniEclipseBuildCommand> buildCommands;

    public BuildCommandUpdater(IProject project, List<OmniEclipseBuildCommand> buildCommands) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.buildCommands = ImmutableList.copyOf(buildCommands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBuildCommands(IProgressMonitor monitor) {
        monitor.beginTask("Updating build commands", 2);
        try {
            StringSetProjectProperty knownCommands = StringSetProjectProperty.from(this.project, PROJECT_PROPERTY_KEY_GRADLE_BUILD_COMMANDS);
            this.addBuildCommandsNewInGradleModel(knownCommands, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.removeBuildCommandsRemovedFromGradleModel(knownCommands, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (CoreException e) {
            CorePlugin.logger().error(String.format("Cannot update build commands on %s.", this.project.getName()), e);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuildCommandsNewInGradleModel(StringSetProjectProperty knownCommands, IProgressMonitor monitor) {
        monitor.beginTask("Add new build commands", this.buildCommands.size());
        try {
            for (OmniEclipseBuildCommand buildCommand : this.buildCommands) {
                String name = buildCommand.getName();
                Map arguments = buildCommand.getArguments();
                CorePlugin.workspaceOperations().addBuildCommand(this.project, name, arguments, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                knownCommands.add(name);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBuildCommandsRemovedFromGradleModel(StringSetProjectProperty knownCommands, IProgressMonitor monitor) throws CoreException {
        Set<String> buildCommands = knownCommands.get();
        monitor.beginTask("Remove old build commands", buildCommands.size());
        try {
            for (String buildCommand : buildCommands) {
                if (!this.buildCommandExistsInGradleModel(buildCommand)) {
                    CorePlugin.workspaceOperations().removeBuildCommand(this.project, buildCommand, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    knownCommands.remove(buildCommand);
                    continue;
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean buildCommandExistsInGradleModel(final String buildCommandName) {
        return FluentIterable.from(this.buildCommands).firstMatch((Predicate)new Predicate<OmniEclipseBuildCommand>(){

            public boolean apply(OmniEclipseBuildCommand command) {
                return command.getName().equals(buildCommandName);
            }
        }).isPresent();
    }

    public static void update(IProject project, Optional<List<OmniEclipseBuildCommand>> buildCommands, IProgressMonitor monitor) throws CoreException {
        List builderCommands = (List)buildCommands.or(Collections.emptyList());
        BuildCommandUpdater updater = new BuildCommandUpdater(project, builderCommands);
        updater.updateBuildCommands(monitor);
    }
}

