/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.BuildLaunchRequest;
import com.gradleware.tooling.toolingclient.LaunchableConfig;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingclient.SingleBuildRequest;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectNature;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;

public class RunOnImportTasksOperation {
    private static final String WTP_TASK = "eclipseWtp";
    private static final String WTP_COMPONENT_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private OmniEclipseGradleBuild gradleBuild;
    private FixedRequestAttributes build;

    public RunOnImportTasksOperation(OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes build) {
        this.gradleBuild = gradleBuild;
        this.build = build;
    }

    public void run(IProgressMonitor monitor, CancellationToken token) throws CoreException {
        Set<String> tasksToRun = this.findWtpTasks();
        if (!tasksToRun.isEmpty()) {
            this.runTasks(tasksToRun, monitor, token);
        }
    }

    private Set<String> findWtpTasks() {
        if (!CorePlugin.workspaceOperations().isNatureRecognizedByEclipse(WTP_COMPONENT_NATURE)) {
            return Collections.emptySet();
        }
        HashSet tasksToRun = Sets.newHashSet();
        for (OmniEclipseProject eclipseProject : this.gradleBuild.getRootEclipseProject().getAll()) {
            if (!this.isGradle30(eclipseProject) || !this.isWtpProject(eclipseProject)) continue;
            List tasks = eclipseProject.getGradleProject().getProjectTasks();
            for (OmniProjectTask task : tasks) {
                if (!WTP_TASK.equals(task.getName())) continue;
                tasksToRun.add(task.getPath().getPath());
            }
        }
        return tasksToRun;
    }

    private boolean isGradle30(OmniEclipseProject eclipseProject) {
        return eclipseProject.getClasspathContainers().isPresent();
    }

    private boolean isWtpProject(OmniEclipseProject eclipseProject) {
        Optional natures = eclipseProject.getProjectNatures();
        if (natures.isPresent()) {
            for (OmniEclipseProjectNature nature : (List)natures.get()) {
                if (!nature.getId().equals(WTP_COMPONENT_NATURE)) continue;
                return true;
            }
        }
        return false;
    }

    private void runTasks(Set<String> tasksToRun, IProgressMonitor monitor, CancellationToken token) {
        BuildLaunchRequest request = CorePlugin.toolingClient().newBuildLaunchRequest(LaunchableConfig.forTasks(tasksToRun));
        this.build.apply((SingleBuildRequest)request);
        this.getTransientRequestAttributes(token, monitor).apply((Request)request);
        request.executeAndWait();
    }

    private TransientRequestAttributes getTransientRequestAttributes(CancellationToken token, IProgressMonitor monitor) {
        ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        ImmutableList progressListeners = ImmutableList.of((Object)DelegatingProgressListener.withoutDuplicateLifecycleEvents(monitor));
        ImmutableList noEventListeners = ImmutableList.of();
        if (token == null) {
            token = GradleConnector.newCancellationTokenSource().token();
        }
        return new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), streams.getInput(), (List)progressListeners, (List)noEventListeners, token);
    }
}

