/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingclient.TestConfig;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.launch.BaseLaunchRequestJob;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;

public final class RunGradleJvmTestMethodLaunchRequestJob
extends BaseLaunchRequestJob {
    private final GradleRunConfigurationAttributes configurationAttributes;
    private ImmutableMap<String, Iterable<String>> classNamesWithMethods;

    public RunGradleJvmTestMethodLaunchRequestJob(Map<String, Iterable<String>> classNamesWithMethods, GradleRunConfigurationAttributes configurationAttributes) {
        super("Launching Gradle Tests", false);
        this.classNamesWithMethods = ImmutableMap.copyOf(classNamesWithMethods);
        this.configurationAttributes = (GradleRunConfigurationAttributes)Preconditions.checkNotNull((Object)configurationAttributes);
    }

    @Override
    protected String getJobTaskName() {
        return "Launch Gradle Test Methods";
    }

    @Override
    protected GradleRunConfigurationAttributes getConfigurationAttributes() {
        return this.configurationAttributes;
    }

    @Override
    protected ProcessDescription createProcessDescription() {
        String processName = this.createProcessName(this.configurationAttributes.getWorkingDir());
        return new TestLaunchProcessDescription(processName);
    }

    private String createProcessName(File workingDir) {
        return String.format("%s [Gradle Project] %s in %s (%s)", Joiner.on((char)' ').join((Iterable)this.classNamesWithMethods.keySet()), Joiner.on((char)' ').join((Iterable)this.classNamesWithMethods.values()), workingDir.getAbsolutePath(), DateFormat.getDateTimeInstance(2, 2).format(new Date()));
    }

    @Override
    protected Request<Void> createRequest() {
        TestConfig.Builder testConfig = new TestConfig.Builder();
        for (Map.Entry classNameWithMethods : this.classNamesWithMethods.entrySet()) {
            testConfig.jvmTestMethods((String)classNameWithMethods.getKey(), (Iterable)classNameWithMethods.getValue());
        }
        return CorePlugin.toolingClient().newTestLaunchRequest(testConfig.build());
    }

    @Override
    protected void writeExtraConfigInfo(OutputStreamWriter writer) throws IOException {
        writer.write(CoreMessages.RunConfiguration_Label_Tests);
        writer.write(": ");
        for (String className : this.classNamesWithMethods.keySet()) {
            for (String methodName : (Iterable)this.classNamesWithMethods.get((Object)className)) {
                writer.write(className);
                writer.write(46);
                writer.write(methodName);
                writer.write("() ");
            }
        }
        writer.write(10);
    }

    private final class TestLaunchProcessDescription
    extends BaseLaunchRequestJob.BaseProcessDescription {
        public TestLaunchProcessDescription(String processName) {
            super(processName, RunGradleJvmTestMethodLaunchRequestJob.this, RunGradleJvmTestMethodLaunchRequestJob.this.configurationAttributes);
        }

        @Override
        public boolean isRerunnable() {
            return true;
        }

        @Override
        public void rerun() {
            RunGradleJvmTestMethodLaunchRequestJob job = new RunGradleJvmTestMethodLaunchRequestJob((Map<String, Iterable<String>>)RunGradleJvmTestMethodLaunchRequestJob.this.classNamesWithMethods, RunGradleJvmTestMethodLaunchRequestJob.this.configurationAttributes);
            job.schedule();
        }
    }
}

