/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.file;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.File;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;

public final class FileUtils {
    private FileUtils() {
    }

    public static Optional<File> getAbsoluteFile(File file) {
        if (file == null) {
            return Optional.absent();
        }
        return Optional.of((Object)(file.isAbsolute() ? file : file.getAbsoluteFile()));
    }

    public static Optional<File> getAbsoluteFile(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return Optional.absent();
        }
        return Optional.of((Object)new File(path.trim()).getAbsoluteFile());
    }

    public static Optional<String> getAbsolutePath(File file) {
        if (file == null) {
            return Optional.absent();
        }
        return Optional.of((Object)file.getAbsolutePath());
    }

    public static void ensureFolderHierarchyExists(IFolder folder) {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                FileUtils.ensureFolderHierarchyExists((IFolder)folder.getParent());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                String message = String.format("Cannot create folder %s.", folder);
                throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
            }
        }
    }

    public static boolean deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] children;
            boolean success = true;
            for (File child : children = file.listFiles()) {
                success &= FileUtils.deleteRecursively(child);
            }
            return success && file.delete();
        }
        return file.delete();
    }
}

