/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniEclipseBuildCommand;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

final class BuildCommandUpdater {
    BuildCommandUpdater() {
    }

    public static void update(IProject project, Optional<List<OmniEclipseBuildCommand>> buildCommands, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        Set<ICommand> commands = BuildCommandUpdater.toCommands(buildCommands, description);
        description.setBuildSpec(commands.toArray(new ICommand[0]));
        project.setDescription(description, monitor);
    }

    private static Set<ICommand> toCommands(Optional<List<OmniEclipseBuildCommand>> buildCommands, IProjectDescription description) {
        LinkedHashSet commands = Sets.newLinkedHashSet();
        if (buildCommands.isPresent()) {
            commands.addAll(BuildCommandUpdater.toCommands((List)buildCommands.get(), description));
        } else {
            commands.addAll(Arrays.asList(description.getBuildSpec()));
        }
        commands.add(BuildCommandUpdater.toCommand(description, "org.eclipse.buildship.core.gradleprojectbuilder", Collections.emptyMap()));
        return commands;
    }

    private static Set<? extends ICommand> toCommands(List<OmniEclipseBuildCommand> buildCommands, IProjectDescription description) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (OmniEclipseBuildCommand buildCommand : buildCommands) {
            result.add(BuildCommandUpdater.toCommand(description, buildCommand.getName(), buildCommand.getArguments()));
        }
        return result;
    }

    private static ICommand toCommand(IProjectDescription description, String name, Map<String, String> arguments) {
        ICommand command = description.newCommand();
        command.setBuilderName(name);
        command.setArguments(arguments);
        return command;
    }
}

