/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.event.EventListener;
import org.eclipse.buildship.ui.internal.util.nodeselection.ActionEnablingSelectionChangedListener;
import org.eclipse.buildship.ui.internal.util.nodeselection.ActionShowingContextMenuListener;
import org.eclipse.buildship.ui.internal.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.internal.util.selection.ContextActivatingViewPartListener;
import org.eclipse.buildship.ui.internal.view.CollapseAllTreeNodesAction;
import org.eclipse.buildship.ui.internal.view.ExpandAllTreeNodesAction;
import org.eclipse.buildship.ui.internal.view.ShowFilterAction;
import org.eclipse.buildship.ui.internal.view.task.CreateRunConfigurationAction;
import org.eclipse.buildship.ui.internal.view.task.FilterPrivateTasksAction;
import org.eclipse.buildship.ui.internal.view.task.FilterProjectTasksAction;
import org.eclipse.buildship.ui.internal.view.task.FilterTaskSelectorsAction;
import org.eclipse.buildship.ui.internal.view.task.GroupTasksAction;
import org.eclipse.buildship.ui.internal.view.task.OpenBuildScriptAction;
import org.eclipse.buildship.ui.internal.view.task.OpenRunConfigurationAction;
import org.eclipse.buildship.ui.internal.view.task.RefreshViewAction;
import org.eclipse.buildship.ui.internal.view.task.RunDefaultTasksAction;
import org.eclipse.buildship.ui.internal.view.task.RunTasksAction;
import org.eclipse.buildship.ui.internal.view.task.ShowFlattenedProjectHierarchy;
import org.eclipse.buildship.ui.internal.view.task.SortTasksByTypeAction;
import org.eclipse.buildship.ui.internal.view.task.SortTasksByVisibilityAction;
import org.eclipse.buildship.ui.internal.view.task.TaskView;
import org.eclipse.buildship.ui.internal.view.task.ToggleLinkToSelectionAction;
import org.eclipse.buildship.ui.internal.view.task.TreeViewerDoubleClickListener;
import org.eclipse.buildship.ui.internal.view.task.TreeViewerSelectionChangeListener;
import org.eclipse.buildship.ui.internal.view.task.WorkbenchSelectionListener;
import org.eclipse.buildship.ui.internal.view.task.WorkspaceProjectsChangeListener;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;

public final class UiContributionManager {
    private static final String TOOLBAR_MISC_GROUP = "toolbarMiscGroup";
    private static final String TOOLBAR_TREE_GROUP = "toolbarTreeGroup";
    private static final String MENU_SORTING_GROUP = "toolbarSortingGroup";
    private static final String MENU_FILTERING_GROUP = "menuFilteringGroup";
    private static final String MENU_GROUPING_GROUP = "menuGroupingGroup";
    private final TaskView taskView;
    private final ImmutableList<SelectionSpecificAction> toolBarActions;
    private final ImmutableList<SelectionSpecificAction> contextMenuActions;
    private final ImmutableList<SelectionSpecificAction> contextMenuActionsPrecededBySeparator;
    private final ImmutableList<SelectionSpecificAction> contextMenuActionsSucceededBySeparator;
    private final ActionEnablingSelectionChangedListener toolBarActionsSelectionChangedListener;
    private final TreeViewerSelectionChangeListener treeViewerSelectionChangeListener;
    private final TreeViewerDoubleClickListener treeViewerDoubleClickListener;
    private final ContextActivatingViewPartListener contextActivatingViewPartListener;
    private final WorkbenchSelectionListener workbenchSelectionListener;
    private final WorkspaceProjectsChangeListener workspaceProjectsChangeListener;

    public UiContributionManager(TaskView taskView) {
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
        RunTasksAction runTasksAction = new RunTasksAction("org.eclipse.buildship.ui.commands.runtasks");
        RunDefaultTasksAction runDefaultTasksAction = new RunDefaultTasksAction("org.eclipse.buildship.ui.commands.rundefaulttasks");
        CreateRunConfigurationAction createRunConfigurationAction = new CreateRunConfigurationAction("org.eclipse.buildship.ui.commands.openrunconfiguration");
        OpenRunConfigurationAction openRunConfigurationAction = new OpenRunConfigurationAction("org.eclipse.buildship.ui.commands.openrunconfiguration");
        OpenBuildScriptAction openBuildScriptAction = new OpenBuildScriptAction("org.eclipse.buildship.ui.commands.openbuildscript");
        this.toolBarActions = ImmutableList.of();
        this.contextMenuActions = ImmutableList.of((Object)runTasksAction, (Object)runDefaultTasksAction, (Object)createRunConfigurationAction, (Object)openRunConfigurationAction, (Object)openBuildScriptAction);
        this.contextMenuActionsPrecededBySeparator = ImmutableList.of((Object)openBuildScriptAction);
        this.contextMenuActionsSucceededBySeparator = ImmutableList.of();
        this.toolBarActionsSelectionChangedListener = new ActionEnablingSelectionChangedListener(taskView, (List<? extends SelectionSpecificAction>)this.toolBarActions);
        this.treeViewerSelectionChangeListener = new TreeViewerSelectionChangeListener(taskView);
        this.treeViewerDoubleClickListener = new TreeViewerDoubleClickListener("org.eclipse.buildship.ui.commands.runtasks", taskView.getTreeViewer());
        this.contextActivatingViewPartListener = new ContextActivatingViewPartListener("org.eclipse.buildship.ui.contexts.taskview", (IViewPart)taskView);
        this.workbenchSelectionListener = new WorkbenchSelectionListener(taskView);
        this.workspaceProjectsChangeListener = new WorkspaceProjectsChangeListener(taskView);
    }

    public void wire() {
        this.populateToolBar();
        this.populateMenu();
        this.registerContextMenu();
        this.registerListeners();
    }

    private void populateToolBar() {
        IToolBarManager manager = this.taskView.getViewSite().getActionBars().getToolBarManager();
        manager.add((IContributionItem)new GroupMarker(TOOLBAR_TREE_GROUP));
        manager.appendToGroup(TOOLBAR_TREE_GROUP, (IAction)new ExpandAllTreeNodesAction((AbstractTreeViewer)this.taskView.getTreeViewer()));
        manager.appendToGroup(TOOLBAR_TREE_GROUP, (IAction)new CollapseAllTreeNodesAction((AbstractTreeViewer)this.taskView.getTreeViewer()));
        manager.appendToGroup(TOOLBAR_TREE_GROUP, (IAction)new ShowFilterAction(this.taskView.getFilteredTree()));
        manager.appendToGroup(TOOLBAR_TREE_GROUP, (IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker(TOOLBAR_MISC_GROUP));
        manager.appendToGroup(TOOLBAR_MISC_GROUP, (IAction)new RefreshViewAction("org.eclipse.buildship.ui.commands.refreshtaskview"));
        manager.appendToGroup(TOOLBAR_MISC_GROUP, (IAction)new ToggleLinkToSelectionAction(this.taskView));
    }

    private void populateMenu() {
        IMenuManager manager = this.taskView.getViewSite().getActionBars().getMenuManager();
        manager.add((IContributionItem)new Separator(MENU_FILTERING_GROUP));
        manager.appendToGroup(MENU_FILTERING_GROUP, (IAction)new FilterTaskSelectorsAction(this.taskView));
        manager.appendToGroup(MENU_FILTERING_GROUP, (IAction)new FilterProjectTasksAction(this.taskView));
        manager.appendToGroup(MENU_FILTERING_GROUP, (IAction)new FilterPrivateTasksAction(this.taskView));
        manager.add((IContributionItem)new Separator(MENU_SORTING_GROUP));
        manager.appendToGroup(MENU_SORTING_GROUP, (IAction)new SortTasksByTypeAction(this.taskView));
        manager.appendToGroup(MENU_SORTING_GROUP, (IAction)new SortTasksByVisibilityAction(this.taskView));
        manager.add((IContributionItem)new Separator(MENU_GROUPING_GROUP));
        manager.appendToGroup(MENU_GROUPING_GROUP, (IAction)new GroupTasksAction(this.taskView));
        manager.appendToGroup(MENU_GROUPING_GROUP, (IAction)new ShowFlattenedProjectHierarchy(this.taskView));
    }

    private void registerContextMenu() {
        TreeViewer treeViewer = this.taskView.getTreeViewer();
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new ActionShowingContextMenuListener(this.taskView, (List<? extends SelectionSpecificAction>)this.contextMenuActions, (List<? extends SelectionSpecificAction>)this.contextMenuActionsPrecededBySeparator, (List<? extends SelectionSpecificAction>)this.contextMenuActionsSucceededBySeparator));
        Menu contextMenu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(contextMenu);
        this.taskView.getViewSite().registerContextMenu(menuManager, (ISelectionProvider)treeViewer);
    }

    private void registerListeners() {
        this.taskView.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this.toolBarActionsSelectionChangedListener);
        this.taskView.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this.treeViewerSelectionChangeListener);
        this.taskView.getTreeViewer().addDoubleClickListener((IDoubleClickListener)this.treeViewerDoubleClickListener);
        this.taskView.getSite().getPage().addPartListener((IPartListener2)this.contextActivatingViewPartListener);
        this.taskView.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.workbenchSelectionListener);
        CorePlugin.listenerRegistry().addEventListener((EventListener)this.workspaceProjectsChangeListener);
    }

    public void dispose() {
        this.taskView.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this.toolBarActionsSelectionChangedListener);
        this.taskView.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this.treeViewerSelectionChangeListener);
        this.taskView.getTreeViewer().removeDoubleClickListener((IDoubleClickListener)this.treeViewerDoubleClickListener);
        this.taskView.getSite().getPage().removePartListener((IPartListener2)this.contextActivatingViewPartListener);
        this.taskView.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.workbenchSelectionListener);
        CorePlugin.listenerRegistry().removeEventListener((EventListener)this.workspaceProjectsChangeListener);
    }
}

