/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.connection.DefaultProjectIdentifier;
import org.gradle.tooling.internal.consumer.converters.CompositeCompatibilityMapping;
import org.gradle.tooling.internal.consumer.converters.EclipseModelCompatibilityMapping;
import org.gradle.tooling.internal.consumer.converters.FixedBuildIdentifierProvider;
import org.gradle.tooling.internal.consumer.converters.GradleProjectIdentifierCompatibilityMapping;
import org.gradle.tooling.internal.consumer.converters.IdeaModelCompatibilityMapping;
import org.gradle.tooling.internal.consumer.converters.TaskDisplayNameCompatibilityMapping;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.model.ProjectIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasCompatibilityMapping {
    private final Action<SourceObjectMapping> taskPropertyHandlerMapper;
    private final Action<SourceObjectMapping> ideaProjectCompatibilityMapper;
    private final Action<SourceObjectMapping> eclipseProjectDependencyCompatibilityMapper;
    private final Action<SourceObjectMapping> gradleProjectIdentifierMapper;

    public HasCompatibilityMapping(VersionDetails versionDetails) {
        this.taskPropertyHandlerMapper = new TaskDisplayNameCompatibilityMapping(versionDetails);
        this.ideaProjectCompatibilityMapper = new IdeaModelCompatibilityMapping(versionDetails);
        this.eclipseProjectDependencyCompatibilityMapper = new EclipseModelCompatibilityMapping(versionDetails);
        this.gradleProjectIdentifierMapper = new GradleProjectIdentifierCompatibilityMapping();
    }

    public Action<SourceObjectMapping> getCompatibilityMapping(ConsumerOperationParameters parameters) {
        DefaultProjectIdentifier projectIdentifier = new DefaultProjectIdentifier(parameters.getBuildIdentifier(), ":");
        return this.getCompatibilityMapping(projectIdentifier);
    }

    public Action<SourceObjectMapping> getCompatibilityMapping(ProjectIdentifier projectIdentifier) {
        FixedBuildIdentifierProvider identifierProvider = new FixedBuildIdentifierProvider(projectIdentifier);
        return this.getCompatibilityMapping(identifierProvider);
    }

    private Action<SourceObjectMapping> getCompatibilityMapping(Action<SourceObjectMapping> requestScopedMapping) {
        return CompositeCompatibilityMapping.builder().add(this.taskPropertyHandlerMapper).add(this.ideaProjectCompatibilityMapper).add(this.eclipseProjectDependencyCompatibilityMapper).add(this.gradleProjectIdentifierMapper).add(requestScopedMapping).build();
    }
}

