/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.operation;

import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.ImportRootProjectException;
import org.eclipse.buildship.core.internal.UnsupportedConfigurationException;
import org.eclipse.buildship.core.internal.UnsupportedJavaVersionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.GradleConnectionException;

public final class ToolingApiStatus
extends Status
implements IStatus {
    private ToolingApiStatus(ToolingApiStatusType type, String workName, Throwable exception) {
        super(type.getSeverity(), "org.eclipse.buildship.core", type.getCode(), String.format(type.messageTemplate(), workName), exception);
    }

    public static ToolingApiStatus from(String workName, Throwable failure) {
        if (failure instanceof OperationCanceledException) {
            return new ToolingApiStatus(ToolingApiStatusType.BUILD_CANCELLED, workName, failure);
        }
        if (failure instanceof BuildCancelledException) {
            return new ToolingApiStatus(ToolingApiStatusType.BUILD_CANCELLED, workName, failure);
        }
        if (failure instanceof BuildException) {
            return new ToolingApiStatus(ToolingApiStatusType.BUILD_FAILED, workName, (Throwable)((BuildException)failure));
        }
        if (failure instanceof GradleConnectionException) {
            return new ToolingApiStatus(ToolingApiStatusType.CONNECTION_FAILED, workName, (Throwable)((GradleConnectionException)failure));
        }
        if (failure instanceof ImportRootProjectException) {
            return new ToolingApiStatus(ToolingApiStatusType.IMPORT_ROOT_DIR_FAILED, workName, (ImportRootProjectException)failure);
        }
        if (failure instanceof UnsupportedConfigurationException) {
            return new ToolingApiStatus(ToolingApiStatusType.UNSUPPORTED_CONFIGURATION, workName, (UnsupportedConfigurationException)failure);
        }
        if (failure instanceof CoreException && ((CoreException)failure).getStatus().getException() != null) {
            return ToolingApiStatus.from(workName, ((CoreException)failure).getStatus().getException());
        }
        if (failure instanceof GradlePluginsRuntimeException) {
            return new ToolingApiStatus(ToolingApiStatusType.PLUGIN_FAILED, workName, (GradlePluginsRuntimeException)failure);
        }
        if (failure instanceof UnsupportedJavaVersionException) {
            return new ToolingApiStatus(ToolingApiStatusType.INCOMPATIBILITY_JAVA, workName, failure);
        }
        return new ToolingApiStatus(ToolingApiStatusType.UNKNOWN, workName, failure);
    }

    public void log() {
        CorePlugin.getInstance().getLog().log((IStatus)this);
    }

    public boolean severityMatches(int severity) {
        return (this.getSeverity() & severity) != 0;
    }

    public static enum ToolingApiStatusType {
        BUILD_CANCELLED(8, "%s was cancelled."),
        IMPORT_ROOT_DIR_FAILED(2, "%s failed due to an error while importing the root project."),
        BUILD_FAILED(2, "%s failed due to an error in the referenced Gradle build."),
        CONNECTION_FAILED(2, "%s failed due to an error connecting to the Gradle build."),
        UNSUPPORTED_CONFIGURATION(2, "%s failed due to an unsupported configuration in the referenced Gradle build."),
        INCOMPATIBILITY_JAVA(2, "%s failed due to an incompatible Java version."),
        PLUGIN_FAILED(4, "%s failed due to an error configuring Eclipse."),
        UNKNOWN(4, "%s failed due to an unexpected error.");

        private final int severity;
        private final String messageTemplate;

        private ToolingApiStatusType(int severity, String messageTemplate) {
            this.severity = severity;
            this.messageTemplate = messageTemplate;
        }

        public int getSeverity() {
            return this.severity;
        }

        public int getCode() {
            return this.ordinal();
        }

        public boolean matches(ToolingApiStatus status) {
            return this.getCode() == status.getCode();
        }

        String messageTemplate() {
            return this.messageTemplate;
        }
    }
}

