/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.mass.design.service.nodes;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.vp.mass.mass.Mass;
import org.polarsys.capella.vp.mass.mass.PartMass;
import org.polarsys.capella.vp.mass.services.MassCapellaService;
import org.polarsys.kitalpha.emde.model.ElementExtension;

public class MassLevelHelper {
    private MassCapellaService maMassService = new MassCapellaService();

    public int computeMass(EObject eObject) {
        int m = this.maMassService.compute(eObject, this.maMassService.getVisitor(), Mass.class);
        ((PartMass)this.maMassService.getMassObject(eObject)).setCurrentMass(m);
        return m;
    }

    public boolean isMassOverhead(EObject eObject, EObject view, EObject container) {
        if (eObject instanceof Mass) {
            return this.evaluateMassStatus(eObject, MassStatus.OVERHEAD);
        }
        return this.computePartStatus((Part)eObject, view, container, MassStatus.OVERHEAD);
    }

    public boolean isMassSaturated(EObject eObject, EObject view, EObject container) {
        if (eObject instanceof Mass) {
            return this.evaluateMassStatus(eObject, MassStatus.SATURATED);
        }
        return this.computePartStatus((Part)eObject, view, container, MassStatus.SATURATED);
    }

    private boolean computePartStatus(Part part, EObject view, EObject container, MassStatus flag) {
        Mass currentPCMass = this.getMassExtension(part);
        if (currentPCMass != null) {
            return this.evaluateMassStatus((EObject)currentPCMass, flag);
        }
        return false;
    }

    private Mass getMassExtension(Part part) {
        EList extensions = part.getOwnedExtensions();
        for (ElementExtension elementExtension : extensions) {
            if (!(elementExtension instanceof Mass)) continue;
            return (Mass)elementExtension;
        }
        return null;
    }

    private boolean evaluateMassStatus(EObject eObject, MassStatus flag) {
        if (eObject instanceof Mass) {
            int current = ((PartMass)eObject).getCurrentMass();
            int maxValue = ((Mass)eObject).getMaxValue();
            if (maxValue <= 0) {
                return false;
            }
            switch (flag) {
                case OVERHEAD: {
                    return current > maxValue;
                }
                case SATURATED: {
                    return current != 0 && current == maxValue;
                }
            }
        }
        return false;
    }

    private static enum MassStatus {
        OVERHEAD,
        SATURATED;

    }
}

