/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.groovy.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.polarsys.capella.groovy.ui.CapellaGroovyUIPlugin;

public class CapellaGroovyDSLSupport
extends ClasspathContainerInitializer {
    public static final IPath CONTAINER_PATH = new Path("CAPELLA_GROOVY_DSL_SUPPORT");

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        JavaCore.setClasspathContainer((IPath)CONTAINER_PATH, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{new DSLDClasspathContainer()}, null);
    }

    private static final class DSLDClasspathContainer
    implements IClasspathContainer {
        private IClasspathEntry[] entries;
        private static final IClasspathEntry[] NO_ENTRIES = new IClasspathEntry[0];

        private DSLDClasspathContainer() {
        }

        public IPath getPath() {
            return CONTAINER_PATH;
        }

        public int getKind() {
            return 1;
        }

        public String getDescription() {
            return "Capella Groovy DSL";
        }

        public IClasspathEntry[] getClasspathEntries() {
            if (this.entries == null) {
                this.entries = this.calculateEntries();
            }
            return this.entries;
        }

        protected IClasspathEntry[] calculateEntries() {
            if (GroovyDSLCoreActivator.getDefault().isDSLDDisabled()) {
                return NO_ENTRIES;
            }
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>();
            try {
                Path folder;
                Enumeration enu = CapellaGroovyUIPlugin.getInstance().getBundle().findEntries(".", "plugin_dsld_support", false);
                if (enu != null && enu.hasMoreElements() && (folder = new Path(FileLocator.toFileURL((URL)((URL)enu.nextElement())).getPath())) != null) {
                    newEntries.add(JavaCore.newLibraryEntry((IPath)folder, null, null));
                }
            }
            catch (Exception e) {
                GroovyDSLCoreActivator.logException((Throwable)e);
            }
            return newEntries.toArray(NO_ENTRIES);
        }
    }
}

