/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.groovy.ui.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.groovy.CapellaGroovyConstants;

public class CapellaScriptMainTab
extends AbstractLaunchConfigurationTab {
    private Label scriptLocationLabel;
    private Text scriptLocationText;
    protected static final String EMPTY_STRING = "";

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.setHelpContextId();
        Group group = new Group(comp, 0);
        group.setFont(font);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        String controlName = "Script Location";
        group.setText(controlName);
        this.scriptLocationText = new Text((Composite)group, 2626);
        this.scriptLocationText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 2: 
                    case 256: 
                    case 512: {
                        e.doit = true;
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 16: {
                        if ((CapellaScriptMainTab.this.scriptLocationText.getStyle() & 4) != 0) {
                            e.doit = true;
                            break;
                        }
                        if (CapellaScriptMainTab.this.scriptLocationText.isEnabled() && (e.stateMask & SWT.MODIFIER_MASK) == 0) break;
                        e.doit = true;
                    }
                }
            }
        });
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.scriptLocationText.setLayoutData((Object)gd);
        this.scriptLocationText.setFont(font);
        this.scriptLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                CapellaScriptMainTab.this.scheduleUpdateJob();
            }
        });
        ControlAccessibleListener.addListener((Control)this.scriptLocationText, (String)group.getText());
        String buttonLabel = "Browse...";
        Button browseButton = this.createPushButton((Composite)group, buttonLabel, null);
        browseButton.setLayoutData((Object)new GridData(128));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ArrayList allScripts = new ArrayList();
                try {
                    ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            if (resource.getType() == 1 && "groovy".equals(((IFile)resource).getFileExtension())) {
                                allScripts.add(resource);
                            }
                            return true;
                        }
                    });
                    ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(CapellaScriptMainTab.this.getShell(), allScripts.toArray(new IResource[allScripts.size()]));
                    if (dialog.open() == 0) {
                        CapellaScriptMainTab.this.scriptLocationText.setText(((IFile)dialog.getResult()[0]).getFullPath().toString());
                    }
                }
                catch (CoreException exception) {
                    StatusManager.getManager().handle(exception, "org.polarsys.capella.groovy.ui");
                }
            }
        });
    }

    protected void setHelpContextId() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_MAIN_TAB);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(CapellaGroovyConstants.LAUNCH_ATTR_SCRIPT_LOCATION.name(), null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.scriptLocationText.setText(configuration.getAttribute(CapellaGroovyConstants.LAUNCH_ATTR_SCRIPT_LOCATION.name(), EMPTY_STRING));
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "org.polarsys.capella.groovy.ui");
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(CapellaGroovyConstants.LAUNCH_ATTR_SCRIPT_LOCATION.name(), this.getAttributeValueFrom(this.scriptLocationText));
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return JavaDebugImages.get((String)"IMG_VIEW_ARGUMENTS_TAB");
    }

    public String getId() {
        return "org.polarsys.capella.groovy.ui.launch.capellaScriptMainTab";
    }
}

