/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.polarsys.capella.groovy.CapellaGroovyConstants;
import org.polarsys.capella.groovy.CapellaGroovyPlugin;

public final class CapellaScriptLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(final ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        WorkspaceJob job = new WorkspaceJob("Capella Groovy Script Execution"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                String location = configuration.getAttribute(CapellaGroovyConstants.LAUNCH_ATTR_SCRIPT_LOCATION.name(), null);
                String[] args = DebugPlugin.parseArguments((String)configuration.getAttribute(CapellaGroovyConstants.LAUNCH_ATTR_PROGRAM_ARGS.name(), ""));
                IFile capellaScriptFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location));
                ArrayList<URL> urls = new ArrayList<URL>();
                if (capellaScriptFile.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject project = JavaCore.create((IProject)capellaScriptFile.getProject());
                    IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        if (entry.getEntryKind() == 1) {
                            try {
                                urls.add(ResourcesPlugin.getWorkspace().getRoot().getFile(entry.getPath()).getLocationURI().toURL());
                            }
                            catch (MalformedURLException e) {
                                CapellaGroovyPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.polarsys.capella.groovy", e.getMessage(), (Throwable)e));
                            }
                        }
                        ++n2;
                    }
                }
                try {
                    Bundle groovy = Platform.getBundle((String)"org.codehaus.groovy");
                    final GroovyClassLoader transformLoader = new GroovyClassLoader(((BundleWiring)groovy.adapt(BundleWiring.class)).getClassLoader());
                    GroovyClassLoader loader = new GroovyClassLoader(((Object)((Object)this)).getClass().getClassLoader()){

                        protected CompilationUnit createCompilationUnit(CompilerConfiguration config, CodeSource source) {
                            return new CompilationUnit(config, source, (GroovyClassLoader)this, transformLoader, true, null, null);
                        }
                    };
                    for (URL u : urls) {
                        loader.addURL(u);
                    }
                    Class cl = loader.parseClass(new GroovyCodeSource(capellaScriptFile.getLocation().toFile(), capellaScriptFile.getCharset()));
                    InvokerHelper.runScript((Class)cl, (String[])args);
                }
                catch (CoreException e) {
                    throw new CoreException((IStatus)new Status(4, "org.polarsys.capella.groovy", e.getMessage(), (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.polarsys.capella.groovy", e.getMessage(), (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

