/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.resourceset.viewer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.ui.action.ViewerFilterAction;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.resource.SiriusRepresentationResourceFactory;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.util.DescriptionResourceImpl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.resourceset.viewer.ResourceSetViewerPlugin;

public class ResourceSetViewer
extends ViewPart {
    public static final String ID = "org.polarsys.capella.resourceset.viewer.ResourceSetViewer";
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action externalizeRepresentation;
    private Action unloadRepresentation;
    private Action loadRepresentation;
    private ViewerFilterAction ecoreFilter;
    private ISelectionListener selectionListener;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory()));
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(CapellaAdapterFactoryProvider.getInstance().getAdapterFactory()));
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceSetViewer.this.updateStatusBar(event.getSelection());
            }
        });
        this.activateListeningToPageSelectionEvents();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    public void updateStatusBar(ISelection selection) {
        IStatusLineManager mgr = this.getViewSite().getActionBars().getStatusLineManager();
        if (mgr != null && selection instanceof ITreeSelection) {
            Object selectedElement = ((ITreeSelection)selection).getFirstElement();
            if (selectedElement instanceof Resource) {
                int gmfElements = 0;
                int siriusElements = 0;
                int semanticElements = 0;
                int otherElements = 0;
                TreeIterator it = ((Resource)selectedElement).getAllContents();
                while (it.hasNext()) {
                    EObject obj = (EObject)it.next();
                    if (obj.eClass().getEPackage().getNsURI().startsWith("http://www.polarsys.org/capella")) {
                        ++semanticElements;
                        continue;
                    }
                    if (obj.eClass().getEPackage().getNsURI().startsWith("http://www.eclipse.org/sirius")) {
                        ++siriusElements;
                        continue;
                    }
                    if (obj.eClass().getEPackage().getNsURI().startsWith("http://www.eclipse.org/gmf")) {
                        ++gmfElements;
                        continue;
                    }
                    ++otherElements;
                }
                if (CapellaResourceHelper.isCapellaResource((Resource)((Resource)selectedElement))) {
                    mgr.setMessage(ResourceSetViewerPlugin.getDefault().getImage("status.png"), "Capella elements : " + Integer.toString(semanticElements) + " / Other EMF elements : " + Integer.toString(otherElements));
                } else if (CapellaResourceHelper.isAirdResource((URI)((Resource)selectedElement).getURI())) {
                    mgr.setMessage(ResourceSetViewerPlugin.getDefault().getImage("status.png"), "Sirius elements : " + Integer.toString(siriusElements) + " / GMF elements : " + Integer.toString(gmfElements) + " / Other EMF elements : " + Integer.toString(otherElements));
                } else {
                    mgr.setMessage(ResourceSetViewerPlugin.getDefault().getImage("status.png"), "EMF elements : " + Integer.toString(otherElements));
                }
            } else {
                mgr.setMessage(null);
            }
        }
    }

    private void makeActions() {
        this.externalizeRepresentation = new Action(){

            public void run() {
                ResourceSetViewer.this.externalizeRepresentation();
            }
        };
        this.externalizeRepresentation.setText("Externalize representation");
        this.externalizeRepresentation.setToolTipText("Externalize representation");
        this.externalizeRepresentation.setImageDescriptor(ResourceSetViewerPlugin.getDefault().getImageDescriptor("externalize.gif"));
        this.unloadRepresentation = new Action(){

            public void run() {
                ResourceSetViewer.this.unloadRepresentation();
            }
        };
        this.unloadRepresentation.setText("Unload representation");
        this.unloadRepresentation.setToolTipText("Unload representation");
        this.unloadRepresentation.setImageDescriptor(ResourceSetViewerPlugin.getDefault().getImageDescriptor("unload.gif"));
        this.loadRepresentation = new Action(){

            public void run() {
                ResourceSetViewer.this.loadRepresentation();
            }
        };
        this.loadRepresentation.setText("Load representation");
        this.loadRepresentation.setToolTipText("Load representation");
        this.loadRepresentation.setImageDescriptor(ResourceSetViewerPlugin.getDefault().getImageDescriptor("load.gif"));
        this.ecoreFilter = new ViewerFilterAction("Filter technical resources", 2){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (this.isChecked()) {
                    String extension;
                    if (element instanceof Resource && ("odesign".equals(extension = ((Resource)element).getURI().fileExtension()) || "ecore".equals(extension))) {
                        return false;
                    }
                    if (element instanceof DescriptionResourceImpl) {
                        return false;
                    }
                }
                return true;
            }
        };
        this.ecoreFilter.addViewer((Viewer)this.viewer);
        this.ecoreFilter.setChecked(true);
        this.ecoreFilter.setToolTipText("Filter technical resources");
        this.ecoreFilter.setImageDescriptor(ResourceSetViewerPlugin.getDefault().getImageDescriptor("filter.gif"));
    }

    protected void unloadRepresentation() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof StructuredSelection) {
            List selectedElements = ((StructuredSelection)selection).toList();
            for (final Object selectedElement : selectedElements) {
                if (!(selectedElement instanceof Resource)) continue;
                TransactionHelper.getExecutionManager((Resource)((Resource)selectedElement)).execute((ICommand)new AbstractReadWriteCommand(){

                    public void run() {
                        ((Resource)selectedElement).unload();
                    }
                });
            }
        }
    }

    protected void loadRepresentation() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof StructuredSelection) {
            List selectedElements = ((StructuredSelection)selection).toList();
            for (final Object selectedElement : selectedElements) {
                if (!(selectedElement instanceof Resource)) continue;
                TransactionHelper.getExecutionManager((Resource)((Resource)selectedElement)).execute((ICommand)new AbstractReadWriteCommand(){

                    public void run() {
                        try {
                            ((Resource)selectedElement).load(Collections.EMPTY_MAP);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    protected void externalizeRepresentation() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof StructuredSelection) {
            List selectedElements = ((StructuredSelection)selection).toList();
            for (final Object selectedElement : selectedElements) {
                if (!(selectedElement instanceof DRepresentation)) continue;
                final Resource[] newResource = new Resource[1];
                final ArrayList descriptors = new ArrayList();
                final ExecutionManager executionManager = TransactionHelper.getExecutionManager((EObject)((EObject)selectedElement));
                final URI airdURI = ((DRepresentation)selectedElement).eResource().getURI();
                executionManager.execute((ICommand)new AbstractReadWriteCommand(){

                    public void run() {
                        Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)selectedElement).getTarget());
                        descriptors.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(DialectManager.INSTANCE.getDescription((DRepresentation)selectedElement), session));
                        String repName = ((DRepresentation)selectedElement).getName().replace(' ', '_');
                        ArrayList<String> srmFileSegments = new ArrayList<String>(airdURI.segmentsList());
                        srmFileSegments.remove(srmFileSegments.size() - 1);
                        srmFileSegments.add("diagrams");
                        srmFileSegments.add(String.valueOf(repName) + "." + "srm");
                        URI resURI = URI.createHierarchicalURI((String)airdURI.scheme(), (String)airdURI.authority(), (String)airdURI.device(), (String[])srmFileSegments.toArray(new String[srmFileSegments.size()]), (String)airdURI.query(), (String)airdURI.fragment());
                        newResource[0] = new SiriusRepresentationResourceFactory().createResource(resURI);
                        newResource[0].getContents().add((Object)((EObject)selectedElement));
                        ((ResourceImpl)newResource[0]).attached((EObject)selectedElement);
                        executionManager.getEditingDomain().getResourceSet().getResources().add((Object)newResource[0]);
                    }
                });
                executionManager.execute((ICommand)new AbstractReadWriteCommand(){

                    public void run() {
                        for (DRepresentationDescriptor descriptor : descriptors) {
                            URI deresolvedURI = newResource[0].getURI().deresolve(airdURI);
                            descriptor.setRepPath(new ResourceDescriptor(deresolvedURI.appendFragment(newResource[0].getURIFragment((EObject)((DRepresentation)selectedElement)))));
                        }
                    }
                });
            }
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ResourceSetViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.externalizeRepresentation);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.unloadRepresentation);
        manager.add((IAction)this.loadRepresentation);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.ecoreFilter);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.externalizeRepresentation);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.unloadRepresentation);
        manager.add((IAction)this.loadRepresentation);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.ecoreFilter);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.externalizeRepresentation);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.unloadRepresentation);
        manager.add((IAction)this.loadRepresentation);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.ecoreFilter);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    public void activateListeningToPageSelectionEvents() {
        this.selectionListener = this.getSelectionListener();
        if (this.selectionListener != null) {
            this.getSite().getPage().addSelectionListener(this.selectionListener);
        }
    }

    protected ISelectionListener getSelectionListener() {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                Object newInput = ResourceSetViewer.this.handleWorkbenchPageSelectionEvent(part, selection);
                if (newInput != null && newInput instanceof ResourceSet) {
                    ResourceSetViewer.this.viewer.setInput(newInput);
                }
            }
        };
    }

    protected Object handleWorkbenchPageSelectionEvent(IWorkbenchPart part_p, ISelection selection_p) {
        Object handledSelection = ResourceSetViewer.handleSelection(part_p, selection_p);
        if (handledSelection instanceof EObject) {
            return TransactionHelper.getEditingDomain((EObject)((EObject)handledSelection)).getResourceSet();
        }
        return handledSelection;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public static Object handleSelection(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection selection_l;
        Object firstElement;
        Object result = null;
        if (selection != null && !selection.isEmpty() && !(part instanceof ResourceSetViewer) && selection instanceof IStructuredSelection && (firstElement = (selection_l = (IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            result = firstElement;
        }
        return result;
    }
}

