/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.command.recorder.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.polarsys.capella.command.recorder.CapellaCommandRecorderActivator;
import org.polarsys.capella.command.recorder.core.manager.AbstractRecorderManager;
import org.polarsys.capella.command.recorder.core.manager.utils.NotificationEnum;
import org.polarsys.capella.command.recorder.core.project.AbstractProjectRecorder;
import org.polarsys.capella.command.recorder.core.recorder.AbstractRecorder;
import org.polarsys.capella.command.recorder.core.writer.INameResolver;
import org.polarsys.capella.command.recorder.core.writer.TXTWriterHelper;
import org.polarsys.capella.command.recorder.internal.utils.CapellaProjectUtils;

public class CapellaProjectRecorder
extends AbstractProjectRecorder {
    protected INameResolver nameResolver = new INameResolver(){

        @Override
        public String getReadableName(EObject eobject) {
            return CapellaProjectUtils.getReadableName(eobject);
        }

        @Override
        public String getID(EObject eobject) {
            return CapellaProjectUtils.getID(eobject);
        }
    };

    public CapellaProjectRecorder(AbstractRecorderManager manager, IProject project) {
        super(manager, project);
    }

    @Override
    public String getExtra() {
        return null;
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (this._events != null && !this._events.isEmpty()) {
            Map<ENotificationImpl, EObject> map = null;
            EObject root = null;
            EObject subRoot = null;
            int depth = -1;
            for (AbstractRecorder.Data data : this._events) {
                map = this.getDirectImpactedObject(data.getNotification());
                for (ENotificationImpl notification : map.keySet()) {
                    boolean shouldBeReported = false;
                    root = (EObject)notification.getNotifier();
                    if (root != null && (CapellaProjectUtils.isCapellaElement(root) || ViewpointPackage.Literals.DREPRESENTATION.isSuperTypeOf(root.eClass()) || CapellaProjectUtils.isDSemanticDecorator((EObject)root.eClass()) != null)) {
                        shouldBeReported = true;
                    }
                    if (!shouldBeReported) continue;
                    depth = 0;
                    String str = NotificationEnum.getOperationEnum(notification.getEventType()).getLiteral();
                    TXTWriterHelper.writeSubEntry(writer, depth, str);
                    root = (EObject)notification.getNotifier();
                    TXTWriterHelper.writeSubEntryForEObject(writer, root, this.nameResolver, ++depth, false);
                    subRoot = map.get(notification);
                    if (subRoot == null) continue;
                    TXTWriterHelper.writeSubEntryForEObject(writer, subRoot, this.nameResolver, ++depth, true);
                }
            }
        }
    }

    private Map<ENotificationImpl, EObject> getDirectImpactedObject(List<Notification> notifications) {
        HashMap<ENotificationImpl, EObject> result = new HashMap<ENotificationImpl, EObject>();
        ENotificationImpl notification = null;
        for (Notification object : notifications) {
            if (!(object instanceof ENotificationImpl)) continue;
            notification = (ENotificationImpl)object;
            EObject eobj = null;
            try {
                switch (notification.getEventType()) {
                    case 1: {
                        eobj = null;
                        break;
                    }
                    case 3: {
                        if (notification.getNewValue() instanceof EObject) {
                            eobj = (EObject)notification.getNewValue();
                        }
                        break;
                    }
                    case 4: {
                        if (notification.getOldValue() instanceof EObject) {
                            eobj = (EObject)notification.getOldValue();
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            result.put(notification, eobj);
        }
        return result;
    }

    @Override
    public void notifyAddSession(Session newSession) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)newSession.getSessionResource());
        if (file != null && file.getProject().equals((Object)this.project)) {
            Writer w = this._manager.getOutputManager().getWriter(this);
            try {
                TXTWriterHelper.writeEntry(w, "DONE Open session " + newSession.getSessionResource().getURI());
                TXTWriterHelper.writeExtraDataLine(w, new Date().toString());
                w.flush();
            }
            catch (IOException e) {
                CapellaCommandRecorderActivator.getDefault().getLog().log((IStatus)new Status(4, CapellaCommandRecorderActivator.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
            }
        }
    }

    @Override
    public void notifyRemoveSession(Session removedSession) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)removedSession.getSessionResource());
        if (file != null && file.getProject().equals((Object)this.project)) {
            Writer w = this._manager.getOutputManager().getWriter(this);
            try {
                TXTWriterHelper.writeEntry(w, "DONE Close session " + removedSession.getSessionResource().getURI());
                TXTWriterHelper.writeExtraDataLine(w, new Date().toString());
                w.flush();
            }
            catch (IOException e) {
                CapellaCommandRecorderActivator.getDefault().getLog().log((IStatus)new Status(4, CapellaCommandRecorderActivator.getDefault().getPluginId(), e.getMessage(), (Throwable)e));
            }
        }
    }
}

