/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.command.recorder.ui.preferences;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.polarsys.capella.command.recorder.core.output.OutputHelper;
import org.polarsys.capella.command.recorder.core.preferences.RecorderCorePreferenceServices;
import org.polarsys.capella.command.recorder.ui.messages.CapellaRecorderUIMessages;
import org.polarsys.capella.command.recorder.ui.preferences.utils.DirectoryFieldEditor2;
import org.polarsys.capella.command.recorder.ui.preferences.utils.IntegerFieldEditor2;
import org.polarsys.capella.common.ui.toolkit.fields.LabelFieldEditor;
import org.polarsys.capella.core.commands.preferences.service.AbstractDefaultPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.UserProfileModeEnum;
import org.polarsys.capella.core.preferences.Activator;

public class RecorderPreferencePage
extends AbstractDefaultPreferencePage {
    protected BooleanFieldEditor _state;
    Map<FieldEditor, Composite> _dynFieldEditors;
    protected final int MAX_SIZE_FOR_INTEGER_ENTRY = 3;
    protected final int WIDTH_FOR_INTEGER_ENTRY = 70;
    protected final int NUMBER_OF_DAY_MIN = 1;
    protected final int NUMBER_OF_DAY_MAX = 30;
    protected static int MAX_FILE_SIZE = 20;
    public static final String PROPERTY_PAGE_ID = "org.polarsys.capella.command.recorder.ui.main";

    public RecorderPreferencePage() {
        super(PROPERTY_PAGE_ID);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void createFieldEditors() {
        this.checkRecorderDir();
        Composite fieldEditorParent = this.getFieldEditorParent();
        this._dynFieldEditors = new HashMap<FieldEditor, Composite>();
        Group mainGroup = this.createGroup(CapellaRecorderUIMessages.recorderPreferencePage_MainGroup_Lbl, CapellaRecorderUIMessages.recorderPreferencePage_MainGroup_ToolTip, fieldEditorParent);
        this._state = new BooleanFieldEditor("recorder_state_pref", CapellaRecorderUIMessages.recorderPreferencePage_ActivateRecording_Lbl, (Composite)mainGroup);
        this.addField((FieldEditor)this._state, UserProfileModeEnum.Expert, (Composite)mainGroup);
        LabelFieldEditor lfe = new LabelFieldEditor("", fieldEditorParent);
        this.addField((FieldEditor)lfe);
        Group historyGroup = this.createGroup(CapellaRecorderUIMessages.recorderPreferencePage_HistoryGroup_Lbl, CapellaRecorderUIMessages.recorderPreferencePage_HistoryGroup_ToolTip, fieldEditorParent);
        BooleanFieldEditor bfe = new BooleanFieldEditor("recorder_create_new_file_on_start_day_pref", CapellaRecorderUIMessages.recorderPreferencePage_CreateNewFileOnStart_Lbl, (Composite)historyGroup);
        BooleanFieldEditor bfe2 = new BooleanFieldEditor("recorder_delete_path_pref", CapellaRecorderUIMessages.recorderPreferencePage_DeleteRecordsOnProjectDeletion_Lbl, (Composite)historyGroup);
        this.addField((FieldEditor)bfe2, UserProfileModeEnum.Expert, (Composite)historyGroup);
        this._dynFieldEditors.put((FieldEditor)bfe2, (Composite)historyGroup);
        this.addField((FieldEditor)bfe, UserProfileModeEnum.Expert, (Composite)historyGroup);
        this._dynFieldEditors.put((FieldEditor)bfe, (Composite)historyGroup);
        IntegerFieldEditor2 ife = new IntegerFieldEditor2("recorder_history_day_pref", CapellaRecorderUIMessages.recorderPreferencePage_HistoryInDay_Lbl, (Composite)historyGroup, 3, 70);
        ife.setValidRange(1, 30);
        this.addField((FieldEditor)ife, UserProfileModeEnum.Expert, (Composite)historyGroup);
        this._dynFieldEditors.put((FieldEditor)ife, (Composite)historyGroup);
        IntegerFieldEditor2 ife2 = new IntegerFieldEditor2("recorder_max_file_sz_pref", CapellaRecorderUIMessages.recorderPreferencePage_MaxFileSize_Lbl, (Composite)historyGroup, 3, 70);
        ife2.setValidRange(1, MAX_FILE_SIZE);
        this.addField((FieldEditor)ife2, UserProfileModeEnum.Expert, (Composite)historyGroup);
        this._dynFieldEditors.put((FieldEditor)ife2, (Composite)historyGroup);
        DirectoryFieldEditor2 dfe = new DirectoryFieldEditor2("recorder_root_path_pref", CapellaRecorderUIMessages.recorderPreferencePage_RecordsLocation_Lbl, (Composite)historyGroup);
        this.addField((FieldEditor)dfe, UserProfileModeEnum.Expert, (Composite)historyGroup);
        this._dynFieldEditors.put((FieldEditor)dfe, (Composite)historyGroup);
        LabelFieldEditor lfe2 = new LabelFieldEditor("", fieldEditorParent);
        this.addField((FieldEditor)lfe2);
        Group contentGroup = this.createGroup(CapellaRecorderUIMessages.recorderPreferencePage_ContentGroup_Lbl, CapellaRecorderUIMessages.recorderPreferencePage_ContentGroup_ToolTip, fieldEditorParent);
        BooleanFieldEditor bfe3 = new BooleanFieldEditor("recorder_extra_data_for_eobject_pref", CapellaRecorderUIMessages.recorderPreferencePage_ExtraData_Lbl, (Composite)contentGroup);
        this.addField((FieldEditor)bfe3, UserProfileModeEnum.Expert, (Composite)contentGroup);
        this._dynFieldEditors.put((FieldEditor)bfe3, (Composite)contentGroup);
        this.enableDisableOptions(RecorderCorePreferenceServices.isRecorderShouldBeRunning());
    }

    protected String getPageDescription() {
        return CapellaRecorderUIMessages.recorderPreferencePage_Desc;
    }

    protected String getPageId() {
        return PROPERTY_PAGE_ID;
    }

    protected String getPageTitle() {
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() instanceof FieldEditor && ((FieldEditor)event.getSource()).getPreferenceName().equals("recorder_state_pref")) {
            this.enableDisableOptions((Boolean)event.getNewValue());
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.enableDisableOptions(false);
    }

    protected void enableDisableOptions(boolean state) {
        for (Map.Entry<FieldEditor, Composite> entry : this._dynFieldEditors.entrySet()) {
            entry.getKey().setEnabled(state, entry.getValue());
        }
    }

    private void checkRecorderDir() {
        File dir = OutputHelper.getRootDirectoryForStorage();
        if (!dir.exists()) {
            dir.mkdir();
        }
    }
}

