/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.command.recorder.ui.view;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.command.recorder.core.manager.utils.NotificationEnum;
import org.polarsys.capella.command.recorder.core.manager.utils.OperationEnum;
import org.polarsys.capella.command.recorder.core.writer.DummyTreeData;
import org.polarsys.capella.command.recorder.ui.view.RecorderSharedImages;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.services.helper.EObjectImageProviderHelper;

public class CapellaRecorderLabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        Image img = null;
        if (columnIndex == 0) {
            EClass ec;
            String[] ds;
            EPackage ep;
            DummyTreeData data = (DummyTreeData)element;
            if (data.getDepth() < 0) {
                String[] ds2 = (String[])data.getData();
                switch (OperationEnum.getOperationEnum((String)ds2[0])) {
                    case DONE: {
                        img = RecorderSharedImages.getImage("view16/done.gif");
                        break;
                    }
                    case UNDO: {
                        img = RecorderSharedImages.getImage("view16/undo.gif");
                        break;
                    }
                    case REDO: {
                        img = RecorderSharedImages.getImage("view16/redo.gif");
                        break;
                    }
                    case NOT_OK: {
                        img = RecorderSharedImages.getImage("view16/delete.gif");
                        break;
                    }
                    default: {
                        img = null;
                        break;
                    }
                }
            } else if (data.getDepth() == 0) {
                String[] ds3 = (String[])data.getData();
                switch (NotificationEnum.getOperationEnum((String)ds3[1])) {
                    case ADD: {
                        img = RecorderSharedImages.getImage("view16/add.gif");
                        break;
                    }
                    case ADD_MANY: {
                        img = RecorderSharedImages.getImage("view16/addmany.gif");
                        break;
                    }
                    case SET: {
                        img = RecorderSharedImages.getImage("view16/set.gif");
                        break;
                    }
                    case REMOVE: {
                        img = RecorderSharedImages.getImage("view16/delete.gif");
                        break;
                    }
                    case REMOVE_MANY: {
                        img = RecorderSharedImages.getImage("view16/deletemany.gif");
                        break;
                    }
                    default: {
                        img = null;
                        break;
                    }
                }
            } else if (data.getDepth() > 0 && data.hasSubData() && (ep = EPackage.Registry.INSTANCE.getEPackage((ds = (String[])data.getSubData())[1])) != null && (ec = (EClass)ep.getEClassifier(ds[0])) != null) {
                img = CapellaRecorderLabelProvider.getImage(ep.getEFactoryInstance().create(ec));
            }
        }
        return img;
    }

    private static Image getImage(EObject eObject) {
        ItemProviderAdapter itemProvider;
        Image result = EObjectImageProviderHelper.getImage((EObject)eObject);
        if (result == null && (itemProvider = CapellaRecorderLabelProvider.getItemProvider(eObject)) != null) {
            result = EObjectImageProviderHelper.getImageFromObject((Object)itemProvider.getImage((Object)eObject));
            itemProvider.dispose();
        }
        return result;
    }

    private static ItemProviderAdapter getItemProvider(EObject object) {
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)TransactionHelper.getEditingDomain((EObject)object);
        IItemLabelProvider provider = (IItemLabelProvider)editingDomain.getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class);
        return (ItemProviderAdapter)provider;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        DummyTreeData data = (DummyTreeData)element;
        String[] ds = (String[])data.getData();
        if (data.getDepth() < 0) {
            if (columnIndex == 0) {
                result = ds[1];
            } else if (1 == columnIndex && data.hasSubData()) {
                result = ((String[])data.getSubData())[0];
            }
        } else if (data.getDepth() == 0) {
            if (columnIndex == 0) {
                result = NotificationEnum.getOperationEnum((String)ds[1]).getLiteral();
            }
        } else if (data.getDepth() > 0 && columnIndex == 0) {
            result = ds[1];
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

