/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.console.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ChoiceKind;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.ocl.requester.console.text.OCLDocument;
import org.polarsys.capella.ocl.requester.decorators.NavigableLabelDecorator;
import org.polarsys.capella.ocl.requester.level.ModelingLevel;

public class OCLCompletionProcessor
implements IContentAssistProcessor {
    private static char[] NO_CHARS = new char[0];
    private static IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private static ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private static char[] ACTIVATION = new char[]{'.', ':', '>', '^'};

    /*
     * Unable to fully structure code
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        doc = (OCLDocument)viewer.getDocument();
        replacementOffset = offset;
        try {
            if (offset > 0 && doc.getChar(offset - 1) == '>' && (offset < 2 || doc.getChar(offset - 2) != '-')) {
                return OCLCompletionProcessor.NO_COMPLETIONS;
            }
            if (offset <= 0 || doc.getChar(offset - 1) != ':' || offset >= 2 && doc.getChar(offset - 2) == ':') ** GOTO lbl-1000
            return OCLCompletionProcessor.NO_COMPLETIONS;
            {
                trigger = doc.getChar(--replacementOffset);
                switch (trigger) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '(': 
                    case '.': 
                    case ':': 
                    case '>': 
                    case '[': 
                    case '^': 
                    case '{': {
                        ++replacementOffset;
                        break block5;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (replacementOffset > 0) continue block5;
                        break block5;
                    }
                }
            }
        }
        catch (BadLocationException e) {
            return OCLCompletionProcessor.NO_COMPLETIONS;
        }
        choices = doc.getOCLChoices(offset);
        return this.createCompletions(choices, replacementOffset, offset - replacementOffset, doc.getModelingLevel());
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return ACTIVATION;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return NO_CHARS;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private ICompletionProposal[] createCompletions(List<Choice> choices, int replacementOffset, int replacementLength, ModelingLevel level) {
        NavigableLabelDecorator decorator = new NavigableLabelDecorator();
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        this.sortChoices(choices);
        for (Choice choice : choices) {
            int cursor;
            String display;
            EModelElement o;
            EAnnotation a;
            boolean addToM2Simplified = false;
            String text = choice.getName();
            Image image = null;
            AdapterFactory ipaf = SiriusEditPlugin.getPlugin().getItemProvidersAdapterFactory();
            IItemLabelProvider obj = (IItemLabelProvider)ipaf.adapt(choice.getElement(), IItemLabelProvider.class);
            image = ExtendedImageRegistry.getInstance().getImage(obj.getImage(choice.getElement()));
            if (choice.getKind() == ChoiceKind.PROPERTY && choice.getElement() instanceof EModelElement && (a = (o = (EModelElement)choice.getElement()).getEAnnotation("http://www.polarsys.org/capella/semantic")) != null) {
                image = decorator.decorateImage(image, choice.getElement());
                addToM2Simplified = true;
            }
            switch (choice.getKind()) {
                case OPERATION: 
                case SIGNAL: {
                    text = String.valueOf(text) + "()";
                    display = choice.getDescription();
                    cursor = text.length() - 1;
                    if (!text.startsWith("ocl")) break;
                    image = decorator.decorateImage(image, choice.getElement());
                    addToM2Simplified = true;
                    break;
                }
                case PROPERTY: 
                case ENUMERATION_LITERAL: 
                case ASSOCIATION_CLASS: 
                case VARIABLE: {
                    display = String.valueOf(text) + " : " + choice.getDescription();
                    cursor = text.length();
                    break;
                }
                default: {
                    display = text;
                    cursor = text.length();
                }
            }
            if (!addToM2Simplified && !ModelingLevel.M2.equals((Object)level) && !ModelingLevel.M1.equals((Object)level)) continue;
            result.add(new CompletionProposal(text, replacementOffset, replacementLength, cursor, image, display, null, null));
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private void sortChoices(List<Choice> choices) {
        Collections.sort(choices, new Comparator<Choice>(){

            @Override
            public int compare(Choice o1, Choice o2) {
                int result = this.rank(o1) - this.rank(o2);
                if (result == 0) {
                    result = o1.getName().compareTo(o2.getName());
                }
                return result;
            }

            private int rank(Choice choice) {
                switch (choice.getKind()) {
                    case VARIABLE: {
                        return 0;
                    }
                    case PACKAGE: {
                        return 1;
                    }
                    case TYPE: {
                        return 2;
                    }
                    case ENUMERATION_LITERAL: {
                        return 3;
                    }
                    case STATE: {
                        return 4;
                    }
                    case PROPERTY: {
                        return 5;
                    }
                    case ASSOCIATION_CLASS: {
                        return 6;
                    }
                    case OPERATION: {
                        return 7;
                    }
                    case SIGNAL: {
                        return 8;
                    }
                }
                return Integer.MAX_VALUE;
            }
        });
    }
}

