/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.validation.design.consistency;

import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.utils.NamingHelper;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.validation.util.CyberValidationHelper;

public class CY_DCON_03_ThreatOrAsset_Realization
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        NamedElement currentElement;
        EObject element = ctx.getTarget();
        BlockArchitecture currentBa = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        if ((element instanceof Threat || element instanceof PrimaryAsset) && !(currentBa instanceof PhysicalArchitecture) && (currentElement = (NamedElement)element).getIncomingTraces().stream().map(trace -> trace.getSourceElement()).filter(elem -> {
            BlockArchitecture elemBa = BlockArchitectureExt.getRootBlockArchitecture((EObject)elem);
            BlockArchitecture prevBa = BlockArchitectureExt.getPreviousBlockArchitecture((BlockArchitecture)elemBa);
            return prevBa.equals(currentBa);
        }).collect(Collectors.toList()).isEmpty()) {
            return ctx.createFailureStatus(new Object[]{currentElement, this.getTitleLabel((EObject)currentElement), EObjectLabelProviderHelper.getMetaclassLabel((EObject)currentElement, (boolean)false), this.getAllocatingArchitecture(currentBa)});
        }
        return ctx.createSuccessStatus();
    }

    private String getTitleLabel(EObject obj) {
        if (obj instanceof Threat) {
            return NamingHelper.getTitleLabel((EObject)obj);
        }
        if (obj instanceof PrimaryAsset) {
            return CyberValidationHelper.getPATitleLabel((PrimaryAsset)obj);
        }
        return "";
    }

    private String getAllocatingArchitecture(BlockArchitecture ba) {
        EList allocatingArch = ba.getAllocatingArchitectures();
        if (!allocatingArch.isEmpty()) {
            BlockArchitecture arch = (BlockArchitecture)allocatingArch.get(0);
            return EObjectLabelProviderHelper.getMetaclassLabel((EObject)arch, (boolean)false);
        }
        return "";
    }
}

