/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.service.IValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class ReflectiveValidationTest
extends BasicTestCase {
    private final String ruleID;
    private final String requiredTestModel;
    protected static final Pattern PATTERN_FAIL = Pattern.compile("_fail$");
    protected static final Pattern PATTERN_OK = Pattern.compile("_ok$");
    protected static final Pattern PATTERN_TEST = Pattern.compile("^test");
    protected Collection<EObject> okElements = new ArrayList<EObject>();
    protected Collection<EObject> failElements = new ArrayList<EObject>();
    protected Collection<EObject> toValidate = new ArrayList<EObject>();

    public ReflectiveValidationTest(String ruleID, String requiredTestModel) {
        this.ruleID = ruleID;
        this.requiredTestModel = requiredTestModel;
    }

    public String getName() {
        return String.valueOf(this.ruleID) + "/ " + this.requiredTestModel;
    }

    public void setUp() throws Exception {
        super.setUp();
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
        CapellaModel model = this.getTestModel(this.getRequiredTestModels().iterator().next());
        TransactionalEditingDomain domain = model.getEditingDomain();
        Project project = model.getProject(domain);
        TreeIterator it = project.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (this.shouldValidate(next)) {
                this.toValidate.add(next);
            }
            if (this.expectOk(next)) {
                this.okElements.add(next);
                continue;
            }
            if (!this.expectFail(next)) continue;
            this.failElements.add(next);
        }
    }

    protected IStatus validate(EObject e) {
        return this.validate(Collections.singleton(e));
    }

    protected IValidator<EObject> getValidator() {
        return ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
    }

    protected IStatus validate(Collection<EObject> elements) {
        ConstraintRegistry registry = ConstraintRegistry.getInstance();
        for (String ruleID : this.getRuleIDs()) {
            IConstraintDescriptor descriptor = registry.getDescriptor(ruleID);
            ReflectiveValidationTest.assertNotNull((String)("Did not find constraint with id " + ruleID + "in the constraint registry"), (Object)descriptor);
            descriptor.setEnabled(true);
        }
        IValidator<EObject> validator = this.getValidator();
        validator.addConstraintFilter(new IConstraintFilter(){

            public boolean accept(IConstraintDescriptor constraint_p, EObject target_p) {
                return ReflectiveValidationTest.this.getRuleIDs().contains(constraint_p.getId());
            }
        });
        return validator.validate(elements);
    }

    protected boolean findName(EObject element, Pattern pattern) {
        if (element instanceof NamedElement) {
            String name = ((NamedElement)element).getName();
            return name != null && pattern.matcher(name).find();
        }
        return false;
    }

    protected boolean matchName(EObject element, Pattern pattern) {
        if (element instanceof NamedElement) {
            String name = ((NamedElement)element).getName();
            return name != null && pattern.matcher(name).matches();
        }
        return false;
    }

    protected boolean shouldValidate(EObject element) {
        return element instanceof Component && this.findName(element, PATTERN_TEST);
    }

    protected boolean expectOk(EObject element) {
        return this.findName(element, PATTERN_OK);
    }

    protected boolean expectFail(EObject element) {
        return this.findName(element, PATTERN_FAIL);
    }

    public void test() throws Exception {
        ReflectiveValidationTest.assertTrue((this.failElements.size() > 0 ? 1 : 0) != 0);
        ReflectiveValidationTest.assertTrue((this.okElements.size() > 0 ? 1 : 0) != 0);
        ReflectiveValidationTest.assertTrue((this.toValidate.size() > 0 ? 1 : 0) != 0);
        this.validateResult(this.validate(this.toValidate));
    }

    protected IStatus find(IStatus root, Predicate<IStatus> pred) {
        ArrayDeque<IStatus> toWork = new ArrayDeque<IStatus>();
        toWork.add(root);
        while (!toWork.isEmpty()) {
            IStatus current = (IStatus)toWork.pop();
            if (pred.test(current)) {
                return current;
            }
            IStatus[] children = current.getChildren();
            int i = 0;
            while (i < children.length) {
                toWork.push(children[children.length - i - 1]);
                ++i;
            }
        }
        return null;
    }

    protected void validateResult(IStatus validationResult) throws Exception {
        IStatus s;
        for (EObject e : this.failElements) {
            s = this.find(validationResult, t -> this.isFailureStatusFor((IStatus)t, e));
            ReflectiveValidationTest.assertNotNull((Object)s);
        }
        for (EObject e : this.okElements) {
            s = this.find(validationResult, t -> this.isFailureStatusFor((IStatus)t, e));
            ReflectiveValidationTest.assertNull((Object)s);
        }
    }

    protected boolean isFailureStatusFor(IStatus status, EObject target) {
        return !status.isOK() && status instanceof ConstraintStatus && ((ConstraintStatus)status).getTarget() == target;
    }

    public List<String> getRequiredTestModels() {
        return Collections.singletonList(this.requiredTestModel);
    }

    protected Collection<String> getRuleIDs() {
        return Collections.singleton(this.ruleID);
    }
}

