/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.properties.sections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.ui.properties.controllers.AbstractMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;
import org.polarsys.capella.core.ui.properties.helpers.DialogHelper;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.ui.properties.sections.Messages;

public abstract class PrimaryAssetInverseMember
extends AbstractSection {
    private PrimaryAssetField primaryAssetMemberships;
    private final EClass assetClass;
    private final EClass memberClass;

    public PrimaryAssetInverseMember(EClass assetClass, EClass memberClass) {
        this.assetClass = assetClass;
        this.memberClass = memberClass;
    }

    public boolean select(Object toTest) {
        return this.memberClass.isInstance((Object)super.selection(toTest));
    }

    protected void createContents(Composite rootParentComposite, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.primaryAssetMemberships = new PrimaryAssetField((Composite)this.getReferencesGroup(), Messages.FunctionCybersecuritySection_FunctionPrimaryAssetProperty_Label, this.getWidgetFactory());
    }

    public void loadData(EObject object) {
        super.loadData(object);
        this.primaryAssetMemberships.loadData(object);
    }

    public List<AbstractSemanticField> getSemanticFields() {
        return Collections.singletonList(this.primaryAssetMemberships);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject newEObject = super.setInputSelection(part, selection);
        this.loadData((EObject)((CapellaElement)newEObject));
    }

    public List<EObject> getAvailableElements(EObject semanticElement) {
        PrimaryAssetController controller = new PrimaryAssetController();
        return controller.doQueryAvailableElements(semanticElement, null);
    }

    public static final class AbstractFunctionSection
    extends PrimaryAssetInverseMember {
        public AbstractFunctionSection() {
            super(CybersecurityPackage.Literals.FUNCTIONAL_PRIMARY_ASSET, FaPackage.Literals.ABSTRACT_FUNCTION);
        }
    }

    public static final class ExchangeItemSection
    extends PrimaryAssetInverseMember {
        public ExchangeItemSection() {
            super(CybersecurityPackage.Literals.INFORMATION_PRIMARY_ASSET, InformationPackage.Literals.EXCHANGE_ITEM);
        }
    }

    public static final class FunctionalChainSection
    extends PrimaryAssetInverseMember {
        public FunctionalChainSection() {
            super(CybersecurityPackage.Literals.FUNCTIONAL_PRIMARY_ASSET, FaPackage.Literals.FUNCTIONAL_CHAIN);
        }
    }

    private class PrimaryAssetController
    extends AbstractMultipleSemanticFieldController {
        private PrimaryAssetController() {
        }

        public List<EObject> loadValues(EObject semanticElement, EStructuralFeature semanticFeature) {
            return this.doQueryCurrentElements(semanticElement, null);
        }

        protected List<EObject> doQueryCurrentElements(EObject semanticElement, IBusinessQuery query) {
            ArrayList<EObject> result = new ArrayList<EObject>();
            ExecutionManager executionManager = TransactionHelper.getExecutionManager((EObject)semanticElement);
            if (executionManager == null) {
                return result;
            }
            SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)executionManager.getEditingDomain();
            if (domain == null) {
                return result;
            }
            SiriusCrossReferenceAdapter crossReferencer = domain.getCrossReferencer();
            if (crossReferencer == null) {
                return result;
            }
            return crossReferencer.getInverseReferences(semanticElement, CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER, true).stream().map(s -> s.getEObject() != null ? ((PrimaryAssetMember)s.getEObject()).getAsset() : null).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }

        protected List<EObject> doQueryAvailableElements(EObject semanticElement, IBusinessQuery query) {
            BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)semanticElement);
            return ItemPropertyDescriptor.getReachableObjectsOfType((EObject)semanticElement, (EClassifier)PrimaryAssetInverseMember.this.assetClass).stream().filter(el -> BlockArchitectureExt.getRootBlockArchitecture((EObject)el).equals(arch)).collect(Collectors.toList());
        }

        protected void doAddOperationInWriteOpenValues(EObject semanticElement, EStructuralFeature semanticFeature, EObject fpa) {
            PrimaryAssetMember m = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m.setMember((ModelElement)semanticElement);
            ((PrimaryAsset)fpa).getOwnedMembers().add((Object)m);
        }

        protected void doRemoveOperationInWriteOpenValues(EObject semanticElement, EStructuralFeature semanticFeature, EObject object) {
            Iterator it = ((PrimaryAsset)object).getOwnedMembers().iterator();
            while (it.hasNext()) {
                PrimaryAssetMember member = (PrimaryAssetMember)it.next();
                if (member.getMember() != semanticElement) continue;
                it.remove();
            }
        }

        protected IBusinessQuery getReadOpenValuesQuery(EObject semanticElement) {
            return null;
        }
    }

    private class PrimaryAssetField
    extends MultipleSemanticField {
        public PrimaryAssetField(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory) {
            super(parent, label, widgetFactory, (IMultipleSemanticFieldController)new PrimaryAssetController());
        }

        protected void doDeleteCommand(EObject element, EStructuralFeature feature) {
            for (EObject fpa : this._controller.loadValues(element, feature)) {
                ((PrimaryAssetController)this._controller).doRemoveOperationInWriteOpenValues(element, feature, fpa);
            }
        }

        protected void handleDeleteButtonClicked() {
            super.handleDeleteButtonClicked();
            this.loadData(this.semanticElement);
        }

        protected List<EObject> openTransferDialog(Button button, List<EObject> currentElements, List<EObject> availableElements, String title, String message) {
            return DialogHelper.openTransferDialog((Control)button, currentElements, availableElements, (String)title, (String)NLS.bind((String)Messages.PrimaryAssetInverseMember_TransferDialogTitle, (Object)EObjectLabelProviderHelper.getText((Object)this.semanticElement)));
        }
    }
}

