/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.transition;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.test.transition.PrimaryAssetTransitionTest;

public class FunctionalPrimaryAssetTransitionTest
extends PrimaryAssetTransitionTest {
    private static final String OPERATIONAL_ACTIVITY_1 = "618e273c-5b56-4855-8a43-18217359fd7b";
    SystemFunction systemFunction;
    LogicalFunction logicalFunction;
    FunctionStorage functionStorage;
    FunctionStorage transitionedFunctionStorage;
    ExchangeItem transitionedExchangeItem;

    @Override
    protected PrimaryAsset createPrimaryAsset() {
        return CybersecurityFactory.eINSTANCE.createFunctionalPrimaryAsset();
    }

    @Override
    protected void checkPAMMembersTransitioned(BlockArchitectureExt.Type level) {
        switch (level) {
            case SA: {
                SystemFunction rootFunctionSA = (SystemFunction)((SystemFunctionPkg)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)this.saArch, (boolean)false)).getOwnedSystemFunctions().get(0);
                this.systemFunction = (SystemFunction)this.mustBeTransitionedDirecltyContainedBy(OPERATIONAL_ACTIVITY_1, (EObject)rootFunctionSA);
                this.transitionedFunctionStorage = (FunctionStorage)this.mustBeTransitionedDirecltyContainedBy(this.functionStorage.getId(), (EObject)this.systemFunction);
                this.transitionedFunctionStorage.getExchangedItems();
                this.transitionedExchangeItem = (ExchangeItem)this.mustBeTransitionedDirecltyContainedBy(this.exchangeItem.getId(), (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)this.saArch, (boolean)false));
                break;
            }
            case LA: {
                LogicalFunction rootFunctionLA = (LogicalFunction)((LogicalFunctionPkg)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)this.laArch, (boolean)false)).getOwnedLogicalFunctions().get(0);
                this.logicalFunction = (LogicalFunction)this.mustBeTransitionedDirecltyContainedBy(this.systemFunction.getId(), (EObject)rootFunctionLA);
                this.transitionedFunctionStorage = (FunctionStorage)this.mustBeTransitionedDirecltyContainedBy(this.transitionedFunctionStorage.getId(), (EObject)this.logicalFunction);
                this.transitionedExchangeItem = (ExchangeItem)this.mustBeTransitionedDirecltyContainedBy(this.transitionedExchangeItem.getId(), (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)this.laArch, (boolean)false));
                break;
            }
            case PA: {
                PhysicalFunction rootFunctionPA = (PhysicalFunction)((PhysicalFunctionPkg)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)this.paArch, (boolean)false)).getOwnedPhysicalFunctions().get(0);
                PhysicalFunction physicalFunction = (PhysicalFunction)this.mustBeTransitionedDirecltyContainedBy(this.logicalFunction.getId(), (EObject)rootFunctionPA);
                this.mustBeTransitionedDirecltyContainedBy(this.transitionedFunctionStorage.getId(), (EObject)physicalFunction);
                this.mustBeTransitionedDirecltyContainedBy(this.transitionedExchangeItem.getId(), (EObject)BlockArchitectureExt.getInterfacePkg((BlockArchitecture)this.paArch, (boolean)false).getOwnedInterfacePkgs().get(0));
                break;
            }
        }
    }

    @Override
    protected void addPAMMembers() {
        OperationalActivity operationalActivity = (OperationalActivity)this.getObject(OPERATIONAL_ACTIVITY_1);
        this.functionStorage = CybersecurityFactory.eINSTANCE.createFunctionStorage();
        this.functionStorage.setDataStorage(true);
        this.functionStorage.setRemanentData(true);
        this.functionStorage.getExchangedItems().add((Object)this.exchangeItem);
        PrimaryAssetMember primaryAssetMember = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
        operationalActivity.getOwnedExtensions().add((Object)this.functionStorage);
        primaryAssetMember.setMember((ModelElement)operationalActivity);
        this.primaryAssetMembers.add(primaryAssetMember);
    }
}

