/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.diffmerge.defer.ui.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.sirius.SiriusDifferenceCategoryProvider;
import org.eclipse.emf.diffmerge.ui.util.GitLikeDiffLabelDecorator;
import org.eclipse.emf.diffmerge.ui.util.IDiffLabelDecorator;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.EnhancedComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategoryProvider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.capella.core.compare.CapellaDiffMergeLabelProvider;
import org.polarsys.capella.diffmerge.defer.ui.DeferredComparisonLoader;
import org.polarsys.capella.diffmerge.defer.ui.EMFDiffMergeDeferUIPlugin;
import org.polarsys.capella.diffmerge.defer.ui.messages.Messages;
import org.polarsys.capella.diffmerge.defer.ui.resources.IResourceChangeHandler;
import org.polarsys.capella.diffmerge.defer.ui.resources.ResourceDeltaVisitor;
import org.polarsys.capella.diffmerge.defer.ui.views.PendingChangesViewUtil;

public class PendingChangesView
extends ViewPart
implements ISaveablePart {
    public static final String VIEW_ID = "org.polarsys.capella.diffmerge.defer.ui.view";
    public static final String PROPERTY_DC_CURRENT = "PROPERTY_DC_CURRENT";
    public static final String PROPERTY_DC_OPEN = "PROPERTY_DC_OPEN";
    protected AbstractComparisonViewer viewer;
    private boolean isSyncedWithEditor;
    protected final Map<Session, DeferredComparisonLoader> sessionToDCMap;
    protected final Map<Session, ViewSessionListener> sessionToListenerMap;
    protected final List<DeferredComparisonLoader> dcLoaders = new LinkedList<DeferredComparisonLoader>();
    protected DeferredComparisonLoader current = null;
    protected IPartListener activePartListener = null;
    protected ISelectionListener selectionServiceListener = null;
    protected IResourceChangeListener resourceChangeListener;
    protected SessionManagerListener viewSessionManagerListener;

    public PendingChangesView() {
        this.sessionToDCMap = new HashMap<Session, DeferredComparisonLoader>();
        this.sessionToListenerMap = new HashMap<Session, ViewSessionListener>();
        this.setSyncedWithEditor(false);
    }

    protected void closeDComparison(DeferredComparisonLoader dcLoader) {
        this.closeDComparisons(Collections.singleton(dcLoader));
    }

    protected void closeDComparisons(Collection<DeferredComparisonLoader> deferredComparisonLoaders) {
        boolean isCurrentAffected = false;
        DeferredComparisonLoader currentDCLoader = this.getCurrent();
        for (DeferredComparisonLoader dcLoader : deferredComparisonLoaders) {
            this.doCloseDComparison(dcLoader);
            boolean bl = isCurrentAffected = isCurrentAffected || currentDCLoader == dcLoader;
        }
        if (isCurrentAffected) {
            this.setCurrent(this.getNewCurrent(currentDCLoader));
        }
        if (!deferredComparisonLoaders.isEmpty()) {
            this.firePartPropertyChangedSync(PROPERTY_DC_OPEN, null, null);
        }
    }

    protected Collection<DeferredComparisonLoader> getDirtyDCLoaders(Collection<DeferredComparisonLoader> deferredComparisonLoaders) {
        HashSet<DeferredComparisonLoader> result = new HashSet<DeferredComparisonLoader>();
        for (DeferredComparisonLoader dcLoader : deferredComparisonLoaders) {
            if (!this.isDirty(dcLoader)) continue;
            result.add(dcLoader);
        }
        return result;
    }

    protected boolean isDirty(DeferredComparisonLoader dcLoader) {
        return dcLoader.getResultingResource() != null && dcLoader.getResultingResource().isModified();
    }

    protected DeferredComparisonLoader getNewCurrent(DeferredComparisonLoader previous) {
        DeferredComparisonLoader result = null;
        Session currentSession = this.getCurrentEditorSession();
        if (currentSession != null) {
            result = this.sessionToDCMap.get(currentSession);
        }
        if (result == null && !this.dcLoaders.isEmpty()) {
            result = this.dcLoaders.get(0);
        }
        return result;
    }

    protected IPartListener createActivePartListener() {
        return new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                Session editorSession;
                if (PendingChangesView.this.isSyncedWithEditor() && (editorSession = PendingChangesView.this.getEditorSession(part)) != null) {
                    DeferredComparisonLoader candidate;
                    Session currentSession;
                    DeferredComparisonLoader currentDCLoader = PendingChangesView.this.getCurrent();
                    Session session = currentSession = currentDCLoader == null ? null : currentDCLoader.getResultingSession();
                    if (editorSession != currentSession && (candidate = PendingChangesView.this.sessionToDCMap.get(editorSession)) != null && candidate != currentDCLoader) {
                        PendingChangesView.this.setCurrent(candidate);
                    }
                }
            }
        };
    }

    protected AbstractComparisonViewer createComparisonViewer(Composite parent) {
        ComparisonViewer result = new ComparisonViewer(parent, this.getActionBars()){

            protected boolean acceptToolBarAdditions(Viewer viewer) {
                return false;
            }

            protected EnhancedComparisonTreeViewer doCreateViewerSynthesis(Composite localParent) {
                return new EnhancedComparisonTreeViewer(localParent){

                    public boolean setHeaderText(String text) {
                        String suffix;
                        String newText = text;
                        if (PendingChangesView.this.isReadOnly() && !newText.endsWith(suffix = PendingChangesView.this.getReadOnlySuffix())) {
                            newText = String.valueOf(newText) + suffix;
                        }
                        return super.setHeaderText(newText);
                    }
                };
            }

            protected IWorkbenchPartSite getSite() {
                return PendingChangesView.this.getSite();
            }
        };
        result.setDelegateLabelProvider((ILabelProvider)CapellaDiffMergeLabelProvider.getInstance());
        result.setDiffLabelDecorator((IDiffLabelDecorator)GitLikeDiffLabelDecorator.getInstance());
        result.setCategoryProvider((IDifferenceCategoryProvider)new SiriusDifferenceCategoryProvider());
        return result;
    }

    protected ActionContributionItem createItemClose(IContributionManager context) {
        Action action = new Action(){

            public void run() {
                if (PendingChangesView.this.isDirty(PendingChangesView.this.getCurrent()) && PendingChangesView.this.getCurrent().getResultingSession() != null) {
                    int choice = SWTUtil.showSaveDialogWithMessage((Object)PendingChangesView.this.getCurrent().getResultingSession(), (String)Messages.PendingChangesView_PendingFileModified, (boolean)true);
                    if (choice == 0) {
                        PendingChangesView.this.doSave((IProgressMonitor)new NullProgressMonitor());
                        PendingChangesView.this.closeDComparison(PendingChangesView.this.getCurrent());
                    } else if (choice == 1) {
                        PendingChangesView.this.closeDComparison(PendingChangesView.this.getCurrent());
                    }
                } else {
                    PendingChangesView.this.closeDComparison(PendingChangesView.this.getCurrent());
                }
            }
        };
        action.setToolTipText(Messages.PendingChangesView_Close_Tooltip);
        action.setImageDescriptor(EMFDiffMergeDeferUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeDeferUIPlugin.ImageID.REMOVE));
        action.setEnabled(false);
        this.addPartPropertyListener(new IPropertyChangeListener((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void propertyChange(PropertyChangeEvent event) {
                if (PendingChangesView.PROPERTY_DC_CURRENT.equals(event.getProperty())) {
                    this.val$action.setEnabled(PendingChangesView.this.getCurrent() != null);
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemLinkWithEditor(IContributionManager context) {
        Action action = new Action(null, 2){

            public void run() {
                PendingChangesView.this.setSyncedWithEditor(this.isChecked());
            }
        };
        action.setChecked(this.isSyncedWithEditor());
        action.setToolTipText(Messages.PendingChangesView_SyncEditor_ToolTip);
        action.setImageDescriptor(EMFDiffMergeUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeUIPlugin.ImageID.SYNCED));
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context.add((IContributionItem)result);
        return result;
    }

    protected ActionContributionItem createItemSelectCurrent(IContributionManager context) {
        final UIUtil.MenuDropDownAction action = new UIUtil.MenuDropDownAction();
        MenuManager mgr = action.getMenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                final DeferredComparisonLoader currentDCLoader = PendingChangesView.this.getCurrent();
                for (final DeferredComparisonLoader loader : PendingChangesView.this.dcLoaders) {
                    String name = PendingChangesViewUtil.getName(loader);
                    Action selectAction = new Action(name, 2){

                        public void run() {
                            if (loader != currentDCLoader) {
                                PendingChangesView.this.setCurrent(loader);
                            }
                        }
                    };
                    selectAction.setChecked(loader == currentDCLoader);
                    manager.add((IAction)selectAction);
                }
            }
        });
        action.setToolTipText(Messages.PendingChangesView_SelectCurrent_Tooltip);
        action.setImageDescriptor(EMFDiffMergeDeferUIPlugin.getDefault().getImageDescriptor(EMFDiffMergeDeferUIPlugin.ImageID.CHANGE_OBJ));
        action.setEnabled(false);
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (PendingChangesView.PROPERTY_DC_OPEN.equals(event.getProperty())) {
                    action.setEnabled(!PendingChangesView.this.dcLoaders.isEmpty());
                }
            }
        });
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        context.add((IContributionItem)result);
        return result;
    }

    public void createPartControl(Composite parent) {
        this.viewer = this.createComparisonViewer(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getControl().setVisible(this.hasContent());
        this.updateContentDescription();
    }

    protected void updateContentDescription() {
        this.setContentDescription(this.computeContentDescription());
    }

    protected String computeContentDescription() {
        if (this.hasContent()) {
            URI pendingFileURI = this.getCurrent().getURI();
            String relativePendingFileURI = PendingChangesViewUtil.getRelativeURI(pendingFileURI);
            URI sessionURI = this.getCurrent().getResultingSessionURI();
            String relativeSessionURI = PendingChangesViewUtil.getRelativeURI(sessionURI);
            return NLS.bind((String)Messages.PendingChangesView_ContentDescription, (Object)(relativePendingFileURI != null ? relativePendingFileURI : pendingFileURI.toString()), (Object)(relativeSessionURI != null ? relativeSessionURI : sessionURI.toString()));
        }
        return Messages.PendingChangesView_NoContentToDisplay;
    }

    protected ISelectionListener createSelectionServiceListener() {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (PendingChangesView.this.isSyncedWithEditor() && part != PendingChangesView.this && PendingChangesView.this.viewer != null && !PendingChangesView.this.viewer.getControl().isDisposed()) {
                    if (PendingChangesView.this.viewer instanceof ComparisonViewer) {
                        ((ComparisonViewer)PendingChangesView.this.viewer).setTreeSelection(selection);
                    } else {
                        PendingChangesView.this.viewer.setSelection(selection, true);
                    }
                }
            }
        };
    }

    protected void createTools() {
        IActionBars actionBars = this.getActionBars();
        assert (actionBars != null);
        IToolBarManager manager = actionBars.getToolBarManager();
        this.createItemClose((IContributionManager)manager);
        this.createItemSelectCurrent((IContributionManager)manager);
        this.createItemLinkWithEditor((IContributionManager)manager);
    }

    public void dispose() {
        super.dispose();
        ArrayList<DeferredComparisonLoader> deferredComparisonLoaders = new ArrayList<DeferredComparisonLoader>(this.dcLoaders);
        this.closeDComparisons(deferredComparisonLoaders);
        IWorkbenchPartSite site = this.getSite();
        if (site != null) {
            if (this.activePartListener != null) {
                site.getPage().removePartListener(this.activePartListener);
                this.activePartListener = null;
            }
            if (this.selectionServiceListener != null) {
                site.getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionServiceListener);
                this.selectionServiceListener = null;
            }
        }
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
        if (this.viewSessionManagerListener != null) {
            SessionManager.INSTANCE.removeSessionsListener(this.viewSessionManagerListener);
        }
    }

    protected void doCloseDComparison(DeferredComparisonLoader dcLoader) {
        this.dcLoaders.remove(dcLoader);
        Session session = dcLoader.getResultingSession();
        if (session != null) {
            this.sessionToDCMap.remove(session);
            ViewSessionListener listener = this.sessionToListenerMap.remove(session);
            session.removeListener((SessionListener)listener);
        }
        dcLoader.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        for (DeferredComparisonLoader loader : this.dcLoaders) {
            this.doSave(loader, monitor);
        }
    }

    private void doSave(DeferredComparisonLoader dcLoader, IProgressMonitor monitor) {
        Resource resultingResource;
        Session currentSession = dcLoader.getResultingSession();
        if (currentSession != null) {
            currentSession.save(monitor);
        }
        if ((resultingResource = dcLoader.getResultingResource()) != null) {
            try {
                resultingResource.save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    protected void fireDirtySync() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PendingChangesView.this.firePropertyChange(257);
            }
        });
    }

    protected void firePartPropertyChangedSync(final String key, final String oldValue, final String newValue) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PendingChangesView.this.firePartPropertyChanged(key, oldValue, newValue);
            }
        });
    }

    protected IActionBars getActionBars() {
        IActionBars result = null;
        IViewSite site = this.getViewSite();
        if (site != null) {
            result = site.getActionBars();
        }
        return result;
    }

    public DeferredComparisonLoader getCurrent() {
        return this.current;
    }

    protected Session getCurrentEditorSession() {
        IEditorPart editor = this.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        return this.getEditorSession((IWorkbenchPart)editor);
    }

    protected Session getEditorSession(IWorkbenchPart workpenchPart) {
        Session result = null;
        if (workpenchPart instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)workpenchPart).getEditorInput();
            if (input instanceof SessionEditorInput) {
                result = ((SessionEditorInput)input).getSession();
            } else if (input != null) {
                result = (Session)input.getAdapter(Session.class);
            }
        }
        return result;
    }

    protected String getReadOnlySuffix() {
        return Messages.PendingChangesView_ReadOnly_Suffix;
    }

    protected boolean hasContent() {
        return this.current != null;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.createTools();
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (PendingChangesView.PROPERTY_DC_CURRENT.equals(event.getProperty())) {
                    PendingChangesView.this.fireDirtySync();
                }
            }
        });
        this.activePartListener = this.createActivePartListener();
        if (this.activePartListener != null) {
            site.getPage().addPartListener(this.activePartListener);
        }
        this.selectionServiceListener = this.createSelectionServiceListener();
        if (this.selectionServiceListener != null) {
            site.getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionServiceListener);
        }
        this.resourceChangeListener = this.createResourceChangedListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        this.viewSessionManagerListener = this.createSessionManagerListener();
        SessionManager.INSTANCE.addSessionsListener(this.viewSessionManagerListener);
    }

    protected SessionManagerListener createSessionManagerListener() {
        return new ViewSessionManagerListener();
    }

    protected IResourceChangeListener createResourceChangedListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(event.getType(), new IResourceChangeHandler(){

                        @Override
                        public void handleFileRemoved(int eventType, IFile file) {
                            if (EMFDiffMergeDeferUIPlugin.getDefault().getFileExtension().equals(file.getFileExtension())) {
                                URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                                PendingChangesView.this.closeDComparisons(PendingChangesViewUtil.getDCLoadersForURI((this).PendingChangesView.this.dcLoaders, fileURI));
                            }
                        }
                    });
                    try {
                        delta.accept((IResourceDeltaVisitor)visitor);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public boolean isDirty() {
        Session currentSession;
        boolean result = false;
        if (this.current != null && (currentSession = this.current.getResultingSession()) != null) {
            result = currentSession.getStatus() == SessionStatus.DIRTY;
        }
        return result;
    }

    protected boolean isReadOnly() {
        boolean result = false;
        DeferredComparisonLoader currentLoader = this.getCurrent();
        if (currentLoader != null) {
            result = currentLoader.isReadOnly();
        }
        return result;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    protected boolean isSyncedWithEditor() {
        return this.isSyncedWithEditor;
    }

    protected void notifyClosingSession(Session session) {
        this.closeDComparison(this.sessionToDCMap.get(session));
    }

    public static PendingChangesView open() {
        PendingChangesView result = null;
        try {
            result = (PendingChangesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(VIEW_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean openURI(URI uri) {
        for (DeferredComparisonLoader deferredComparisonLoader : this.dcLoaders) {
            if (!deferredComparisonLoader.getURI().equals(uri)) continue;
            this.setCurrent(deferredComparisonLoader);
            return deferredComparisonLoader.isSuccessful();
        }
        DeferredComparisonLoader loader = new DeferredComparisonLoader(uri, DeferredComparisonLoader.DeferredComparisonUsage.WRITE_IN_EXISTING_SESSION);
        loader.run();
        boolean result = loader.isSuccessful();
        if (result) {
            List contents = loader.getResultingDiffNode().getActualComparison().getContents();
            for (Object match : contents) {
                if (!(match instanceof EMatch) || ((EMatch)match).getTarget() != null && !((EMatch)match).getTarget().eIsProxy()) continue;
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.PendingChangesView_Error, (String)Messages.PendingChangesView_ErrorMsg);
                return false;
            }
            this.registerDComparison(loader);
        }
        return result;
    }

    protected void registerDComparison(DeferredComparisonLoader dcLoader) {
        boolean proceed = true;
        Session session = dcLoader.getResultingSession();
        if (session != null) {
            boolean sessionRegistered;
            DeferredComparisonLoader previous = this.sessionToDCMap.get(session);
            boolean bl = sessionRegistered = previous != null;
            if (sessionRegistered) {
                String previousName = PendingChangesViewUtil.getName(previous);
                proceed = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)this.getPartName(), (String)String.format(Messages.PendingChangesView_ConfirmReplace, previousName));
                if (proceed) {
                    this.closeDComparison(previous);
                }
            }
            if (proceed) {
                this.sessionToDCMap.put(session, dcLoader);
                ViewSessionListener listener = new ViewSessionListener(session);
                this.sessionToListenerMap.put(session, listener);
                session.addListener((SessionListener)listener);
            }
        }
        if (proceed) {
            this.dcLoaders.add(dcLoader);
            this.setCurrent(dcLoader);
            this.firePartPropertyChangedSync(PROPERTY_DC_OPEN, null, null);
        }
    }

    protected void setCurrent(DeferredComparisonLoader loader) {
        Composite control;
        this.current = loader;
        if (this.viewer != null && (control = this.viewer.getControl()) != null && !control.isDisposed()) {
            Display.getDefault().syncExec(new Runnable((Control)control, loader){
                private final /* synthetic */ Control val$control;
                private final /* synthetic */ DeferredComparisonLoader val$loader;
                {
                    this.val$control = control;
                    this.val$loader = deferredComparisonLoader;
                }

                @Override
                public void run() {
                    this.val$control.setVisible(PendingChangesView.this.hasContent());
                    PendingChangesView.this.updateContentDescription();
                    if (this.val$loader != null) {
                        EnhancedComparisonTreeViewer synthesisViewer;
                        EMFDiffNode diffNode = this.val$loader.getResultingDiffNode();
                        PendingChangesView.this.viewer.setInput((Object)diffNode);
                        if (PendingChangesView.this.viewer instanceof ComparisonViewer && (synthesisViewer = ((ComparisonViewer)PendingChangesView.this.viewer).getSynthesisViewer()) != null) {
                            synthesisViewer.setHeaderText(synthesisViewer.getDefaultHeaderText());
                        }
                    }
                    PendingChangesView.this.firePartPropertyChanged(PendingChangesView.PROPERTY_DC_CURRENT, null, null);
                }
            });
        }
    }

    public void setFocus() {
        Composite viewerControl;
        if (this.viewer != null && (viewerControl = this.viewer.getControl()) != null && !viewerControl.isDisposed()) {
            viewerControl.setFocus();
        }
    }

    protected void setSyncedWithEditor(boolean synced) {
        this.isSyncedWithEditor = synced;
    }

    protected class ViewSessionListener
    implements SessionListener {
        protected final Session targetSession;

        public ViewSessionListener(Session session) {
            this.targetSession = session;
        }

        public void notify(int changeKind) {
            switch (changeKind) {
                case 8: {
                    PendingChangesView.this.notifyClosingSession(this.targetSession);
                    break;
                }
                case 2: 
                case 3: {
                    PendingChangesView.this.fireDirtySync();
                }
            }
        }
    }

    protected class ViewSessionManagerListener
    extends SessionManagerListener.Stub {
        protected ViewSessionManagerListener() {
        }

        public void notifyAddSession(Session newSession) {
            Collection<DeferredComparisonLoader> dcLoadersWithNullSession = PendingChangesViewUtil.getDCLoadersWithNullSession(PendingChangesView.this.dcLoaders);
            if (!dcLoadersWithNullSession.isEmpty()) {
                Collection<DeferredComparisonLoader> dcLoadersRelatedToSession = PendingChangesViewUtil.getDCLoadersRelatedToSession(dcLoadersWithNullSession, newSession);
                for (DeferredComparisonLoader dcLoader : dcLoadersRelatedToSession) {
                    URI uri = dcLoader.getURI();
                    PendingChangesView.this.closeDComparison(dcLoader);
                    PendingChangesView.this.openURI(uri);
                }
            }
        }
    }
}

