/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.diffmerge.defer.ui.views;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.ui.util.UserProperty;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.diffmerge.defer.ui.DeferredComparisonLoader;

public class PendingChangesViewUtil {
    public static UserProperty.Identifier<DeferredComparisonLoader> P_DEFERRED_LOADER = new UserProperty.Identifier("PROPERTY_DEFERRED_LOADER");

    private PendingChangesViewUtil() {
    }

    public static Collection<DeferredComparisonLoader> getDCLoadersWithNullSession(Collection<DeferredComparisonLoader> dcLoaders) {
        HashSet<DeferredComparisonLoader> result = new HashSet<DeferredComparisonLoader>();
        for (DeferredComparisonLoader loader : dcLoaders) {
            if (loader.getResultingSession() != null) continue;
            result.add(loader);
        }
        return result;
    }

    public static Collection<DeferredComparisonLoader> getDCLoadersRelatedToSession(Collection<DeferredComparisonLoader> dcLoaders, Session session) {
        HashSet<DeferredComparisonLoader> result = new HashSet<DeferredComparisonLoader>();
        Resource sessionResource = session.getSessionResource();
        if (sessionResource != null && sessionResource.getURI() != null) {
            URI uri = sessionResource.getURI();
            for (DeferredComparisonLoader loader : dcLoaders) {
                if (!uri.equals(loader.getResultingSessionURI())) continue;
                result.add(loader);
            }
        }
        return result;
    }

    public static Collection<DeferredComparisonLoader> getDCLoadersForURI(Collection<DeferredComparisonLoader> dcLoaders, URI uri) {
        HashSet<DeferredComparisonLoader> result = new HashSet<DeferredComparisonLoader>();
        for (DeferredComparisonLoader loader : dcLoaders) {
            if (!uri.equals(loader.getURI())) continue;
            result.add(loader);
        }
        return result;
    }

    public static String getName(DeferredComparisonLoader loader) {
        return PendingChangesViewUtil.getRelativeURI(loader.getURI());
    }

    public static String getRelativeURI(URI uri) {
        String result = null;
        result = uri.toPlatformString(true);
        if (result != null && result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public static IPath getAutoNewNameFor(IPath originalName, IWorkspace workspace) {
        String resourceName = originalName.lastSegment();
        IPath leadupSegment = originalName.removeLastSegments(1);
        boolean isFile = !originalName.hasTrailingSeparator();
        String newName = resourceName;
        while (true) {
            IPath pathToTry = leadupSegment.append(newName);
            if (!workspace.getRoot().exists(pathToTry)) {
                return pathToTry;
            }
            newName = PendingChangesViewUtil.computeNewName(newName, isFile);
        }
    }

    private static String computeNewName(String baseName, boolean isFile) {
        Pattern p;
        Matcher m;
        int lastIndexOfDot = baseName.lastIndexOf(46);
        String fileExtension = "";
        String fileNameNoExtension = baseName;
        if (isFile && lastIndexOfDot > 0) {
            fileExtension = baseName.substring(lastIndexOfDot);
            fileNameNoExtension = baseName.substring(0, lastIndexOfDot);
        }
        if ((m = (p = Pattern.compile("[0-9]+$")).matcher(fileNameNoExtension)).find()) {
            int newNumber = Integer.parseInt(m.group()) + 1;
            String numberStr = m.replaceFirst(Integer.toString(newNumber));
            return String.valueOf(numberStr) + fileExtension;
        }
        return String.valueOf(fileNameNoExtension) + "2" + fileExtension;
    }

    public static IFile getFile(URI uri) {
        if (uri != null && Platform.isRunning()) {
            ResourceImpl resource = new ResourceImpl(uri);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResources().add((Object)resource);
            resourceSet.setURIConverter(PendingChangesViewUtil.getURIConverter(null));
            return PendingChangesViewUtil.getFile((Resource)resource);
        }
        return null;
    }

    public static IFile getFile(Resource resource) {
        if (resource != null && Platform.isRunning()) {
            return WorkspaceSynchronizer.getFile((Resource)resource);
        }
        return null;
    }

    public static URIConverter getURIConverter(ResourceSet resourceSet) {
        Object uriConverter = resourceSet != null ? resourceSet.getURIConverter() : new ExtensibleURIConverterImpl();
        if (Platform.isRunning()) {
            IPath workspaceRootPath = ResourcesPlugin.getWorkspace().getRoot().getFullPath().addTrailingSeparator();
            URI workspaceRootURI = URI.createPlatformResourceURI((String)workspaceRootPath.toString(), (boolean)true);
            IPath workspaceRootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().addTrailingSeparator();
            URI workspaceRootLocationURI = URI.createURI((String)workspaceRootLocation.toString(), (boolean)true);
            URI workspaceRootLocationFileURI = URI.createFileURI((String)workspaceRootLocation.toString());
            uriConverter.getURIMap().put(workspaceRootLocationURI, workspaceRootURI);
            uriConverter.getURIMap().put(workspaceRootLocationFileURI, workspaceRootURI);
        }
        return uriConverter;
    }
}

